/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.concepts.majordomo;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.zeromq.SocketType;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.util.ZData;
import zmq.Msg;
import zmq.SocketBase;

public class MajordomoProtocol {
    public static final byte[] EMPTY_FRAME = new byte[0];
    private static final String HEX_CHAR = "0123456789ABCDEF";

    public static MdpMessage receiveMdpMessage(ZMQ.Socket socket) {
        return MajordomoProtocol.receiveMdpMessage(socket, true);
    }

    public static MdpMessage receiveMdpMessage(ZMQ.Socket socket, boolean wait) {
        byte[] senderId;
        assert (socket != null) : "socket must not be null";
        int flags = wait ? 0 : 1;
        ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)socket, (int)flags);
        if (msg == null) {
            return null;
        }
        assert (msg.size() >= 3);
        if (socket.getSocketType() == SocketType.ROUTER) {
            senderId = msg.pop().getData();
            assert (senderId != null) : "first sender frame is empty";
        } else {
            senderId = null;
        }
        ZFrame emptyFrame = msg.pop();
        assert (emptyFrame.hasData() && emptyFrame.getData().length == 0) : "nominally empty message has data: " + emptyFrame.getData().length + " - '" + emptyFrame.toString() + "'";
        ZFrame protocolFrame = msg.pop();
        assert (protocolFrame.hasData());
        MdpSubProtocol protocol = MdpSubProtocol.getProtocol(protocolFrame);
        switch (protocol) {
            case C_CLIENT: {
                assert (msg.size() >= 2);
                MdpClientCommand clientCommand = MdpClientCommand.getCommand(MdpClientCommand.C_UNKNOWN.newFrame());
                ZFrame serviceName = msg.pop();
                assert (serviceName.getData() != null) : "empty serviceName";
                byte[][] clientMessages = new byte[msg.size()][];
                for (int i = 0; i < clientMessages.length; ++i) {
                    ZFrame dataFrame = msg.pop();
                    clientMessages[i] = dataFrame.hasData() ? dataFrame.getData() : EMPTY_FRAME;
                    dataFrame.destroy();
                }
                return new MdpClientMessage(senderId, clientCommand, serviceName.getData(), (byte[][])clientMessages);
            }
            case W_WORKER: {
                ZFrame commandFrame = msg.pop();
                assert (protocolFrame.hasData());
                MdpWorkerCommand workerCommand = MdpWorkerCommand.getCommand(commandFrame);
                switch (workerCommand) {
                    case W_HEARTBEAT: 
                    case W_DISCONNECT: {
                        assert (msg.isEmpty()) : "MDP V0.1 does not support further frames for W_HEARTBEAT or W_DISCONNECT";
                        return new MdpWorkerMessage(senderId, workerCommand, null, null, (byte[][])new byte[0][]);
                    }
                    case W_READY: {
                        return new MdpWorkerMessage(senderId, workerCommand, msg.isEmpty() ? null : msg.pop().getData(), null, (byte[][])new byte[0][]);
                    }
                    case W_REQUEST: 
                    case W_REPLY: {
                        byte[] clientSourceId = msg.pop().getData();
                        assert (clientSourceId != null) : "clientSourceID must not be null";
                        ZFrame emptyFrame2 = msg.pop();
                        assert (emptyFrame2.hasData() && emptyFrame2.getData().length == 0) : "nominally empty message has data: " + emptyFrame2.getData().length + " - '" + emptyFrame2.toString() + "'";
                        byte[][] workerMessages = new byte[msg.size()][];
                        for (int i = 0; i < workerMessages.length; ++i) {
                            ZFrame dataFrame = msg.pop();
                            workerMessages[i] = dataFrame.hasData() ? dataFrame.getData() : EMPTY_FRAME;
                            dataFrame.destroy();
                        }
                        return new MdpWorkerMessage(senderId, workerCommand, null, clientSourceId, (byte[][])workerMessages);
                    }
                }
                assert (false) : "should not reach here for production code";
                return null;
            }
        }
        assert (false) : "should not reach here for production code";
        return null;
    }

    public static boolean sendClientMessage(ZMQ.Socket socket, MdpClientCommand mdpClientCommand, byte[] sourceID, byte[] serviceName, byte[] ... msg) {
        assert (socket != null) : "socket must not be null";
        assert (mdpClientCommand != null) : "mdpClientCommand must not be null";
        assert (serviceName != null) : "serviceName must not be null";
        SocketBase socketBase = socket.base();
        boolean status = true;
        if (socket.getSocketType() == SocketType.ROUTER) {
            assert (sourceID != null) : "sourceID must be non-null when using ROUTER sockets";
            status = socketBase.send(new Msg(sourceID), 2);
        }
        status &= socketBase.send(new Msg(EMPTY_FRAME), 2);
        status &= socketBase.send(new Msg(MdpSubProtocol.C_CLIENT.getFrameData()), 2);
        status &= socketBase.send(new Msg(serviceName), 2);
        for (int i = 0; i < msg.length; ++i) {
            status &= socketBase.send(new Msg(msg[i]), i < msg.length - 1 ? 2 : 0);
        }
        return status;
    }

    public static boolean sendWorkerMessage(ZMQ.Socket socket, MdpWorkerCommand mdpWorkerCommand, byte[] sourceID, byte[] clientID, byte[] ... msg) {
        assert (socket != null) : "socket must not be null";
        assert (mdpWorkerCommand != null) : "mdpWorkerCommand must not be null";
        SocketBase socketBase = socket.base();
        boolean status = true;
        if (socket.getSocketType() == SocketType.ROUTER) {
            assert (sourceID != null) : "sourceID must be non-null when using ROUTER sockets";
            status = socketBase.send(new Msg(sourceID), 2);
        }
        socketBase.send(new Msg(EMPTY_FRAME), 2);
        socketBase.send(new Msg(MdpSubProtocol.W_WORKER.getFrameData()), 2);
        switch (mdpWorkerCommand) {
            case W_HEARTBEAT: 
            case W_DISCONNECT: {
                assert (msg.length == 0) : "byte[]... msg must be empty for W_HEARTBEAT and W_DISCONNECT commands";
                return status &= socketBase.send(new Msg(mdpWorkerCommand.getFrameData()), 0);
            }
            case W_READY: 
            case W_REQUEST: 
            case W_REPLY: {
                socketBase.send(new Msg(mdpWorkerCommand.getFrameData()), 2);
                assert (clientID != null);
                if (msg.length == 0 && mdpWorkerCommand == MdpWorkerCommand.W_READY) {
                    status &= socketBase.send(new Msg(clientID), 0);
                } else {
                    assert (msg.length != 0) : "byte[]... msg must not be empty";
                    status &= socketBase.send(new Msg(clientID), 2);
                    status &= socketBase.send(new Msg(EMPTY_FRAME), 2);
                    for (int i = 0; i < msg.length; ++i) {
                        status &= socketBase.send(new Msg(msg[i]), i < msg.length - 1 ? 2 : 0);
                    }
                }
                return status;
            }
        }
        throw new IllegalArgumentException("should not reach here/unknown command: " + mdpWorkerCommand);
    }

    public static String strhex(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (byte aData : data) {
            int b1 = aData >>> 4 & 0xF;
            int b2 = aData & 0xF;
            b.append(HEX_CHAR.charAt(b1));
            b.append(HEX_CHAR.charAt(b2));
        }
        return b.toString();
    }

    public static class MdpWorkerMessage
    extends MdpMessage {
        public final MdpWorkerCommand command;
        public final byte[] serviceNameBytes;
        public final String serviceName;
        public final byte[] clientSourceID;
        public final String clientSourceName;

        public MdpWorkerMessage(byte[] senderID, MdpWorkerCommand workerCommand, byte[] serviceName, byte[] clientSourceID, byte[] ... workerMessages) {
            super(senderID, MdpSubProtocol.W_WORKER, workerMessages);
            this.command = workerCommand;
            this.serviceNameBytes = serviceName;
            this.serviceName = serviceName == null ? null : new String(serviceName, StandardCharsets.UTF_8);
            this.clientSourceID = clientSourceID;
            this.clientSourceName = clientSourceID == null ? null : new String(clientSourceID, StandardCharsets.UTF_8);
        }

        @Override
        public String toString() {
            return "MdpWorkerMessage{senderID=" + ZData.toString((byte[])this.senderID) + ", command=" + this.command + ", serviceName='" + this.serviceName + "', clientSourceID='" + ZData.toString((byte[])this.clientSourceID) + "', payload=" + MdpWorkerMessage.toString(this.payload) + "}";
        }
    }

    public static class MdpClientMessage
    extends MdpMessage {
        public final MdpClientCommand command;
        public final byte[] serviceNameBytes;
        public final String serviceName;

        public MdpClientMessage(byte[] senderID, MdpClientCommand clientCommand, byte[] serviceNameBytes, byte[] ... clientMessages) {
            super(senderID, MdpSubProtocol.C_CLIENT, clientMessages);
            this.command = clientCommand;
            this.serviceNameBytes = serviceNameBytes;
            this.serviceName = new String(serviceNameBytes, StandardCharsets.UTF_8);
        }

        @Override
        public String toString() {
            return "MdpClientMessage{senderID=" + ZData.toString((byte[])this.senderID) + ", serviceName='" + this.serviceName + "', payload=" + MdpClientMessage.toString(this.payload) + "}";
        }
    }

    public static class MdpMessage {
        public final MdpSubProtocol protocol;
        public final boolean isClient;
        public final byte[] senderID;
        public final String senderIdHex;
        public final String senderName;
        public final byte[][] payload;

        public MdpMessage(byte[] senderID, MdpSubProtocol protocol, byte[] ... payload) {
            this.isClient = protocol == MdpSubProtocol.C_CLIENT;
            this.senderID = senderID;
            this.senderIdHex = MajordomoProtocol.strhex(senderID);
            this.senderName = senderID == null ? null : new String(senderID, StandardCharsets.UTF_8);
            this.protocol = protocol;
            this.payload = payload;
        }

        public byte[] getRbacFrame() {
            if (this.hasRbackToken()) {
                byte[] rbacFrame = this.payload[this.payload.length - 1];
                return Arrays.copyOf(rbacFrame, rbacFrame.length);
            }
            return new byte[0];
        }

        public boolean hasRbackToken() {
            return this.payload.length >= 2;
        }

        public String toString() {
            return "MdpMessage{isClient=" + this.isClient + ", senderID=" + ZData.toString((byte[])this.senderID) + ", payload=" + MdpMessage.toString(this.payload) + "}";
        }

        protected static String toString(byte[][] byteValue) {
            if (byteValue == null) {
                return "(null)";
            }
            if (byteValue.length == 0) {
                return "[]";
            }
            if (byteValue.length == 1) {
                return "[" + ZData.toString((byte[])byteValue[0]) + "]";
            }
            StringBuilder b = new StringBuilder();
            b.append('[').append(ZData.toString((byte[])byteValue[0]));
            for (int i = 1; i < byteValue.length; ++i) {
                b.append(", ").append(ZData.toString((byte[])byteValue[i]));
            }
            b.append(']');
            return b.toString();
        }
    }

    public static enum MdpClientCommand {
        C_UNKNOWN(-1);

        private final byte[] data;

        private MdpClientCommand(int value) {
            this.data = new byte[]{(byte)(value & 0xFF)};
        }

        public boolean frameEquals(ZFrame frame) {
            return Arrays.equals(this.data, frame.getData());
        }

        public byte[] getFrameData() {
            return this.data;
        }

        public ZFrame newFrame() {
            return new ZFrame(this.data);
        }

        public static MdpClientCommand getCommand(ZFrame frame) {
            for (MdpClientCommand knownMdpCommand : MdpClientCommand.values()) {
                if (!knownMdpCommand.frameEquals(frame) || knownMdpCommand == C_UNKNOWN) continue;
                return knownMdpCommand;
            }
            return C_UNKNOWN;
        }
    }

    public static enum MdpWorkerCommand {
        W_READY(1),
        W_REQUEST(2),
        W_REPLY(3),
        W_HEARTBEAT(4),
        W_DISCONNECT(5),
        W_UNKNOWN(-1);

        private final byte[] data;

        private MdpWorkerCommand(int value) {
            this.data = new byte[]{(byte)(value & 0xFF)};
        }

        public boolean frameEquals(ZFrame frame) {
            return Arrays.equals(this.data, frame.getData());
        }

        public byte[] getFrameData() {
            return this.data;
        }

        public ZFrame newFrame() {
            return new ZFrame(this.data);
        }

        public static MdpWorkerCommand getCommand(ZFrame frame) {
            for (MdpWorkerCommand knownMdpCommand : MdpWorkerCommand.values()) {
                if (!knownMdpCommand.frameEquals(frame) || knownMdpCommand == W_UNKNOWN) continue;
                return knownMdpCommand;
            }
            return W_UNKNOWN;
        }
    }

    public static enum MdpSubProtocol {
        C_CLIENT("MDPC01"),
        W_WORKER("MDPW01"),
        UNKNOWN("XXXXXX");

        private final byte[] data;

        private MdpSubProtocol(String value) {
            this.data = value.getBytes(StandardCharsets.UTF_8);
        }

        public boolean frameEquals(ZFrame frame) {
            return Arrays.equals(this.data, frame.getData());
        }

        public byte[] getFrameData() {
            return this.data;
        }

        public boolean isEquals(byte[] other) {
            return Arrays.equals(this.data, other);
        }

        public ZFrame newFrame() {
            return new ZFrame(this.data);
        }

        public static MdpSubProtocol getProtocol(ZFrame frame) {
            for (MdpSubProtocol knownProtocol : MdpSubProtocol.values()) {
                if (!knownProtocol.frameEquals(frame) || knownProtocol == UNKNOWN) continue;
                return knownProtocol;
            }
            return UNKNOWN;
        }
    }
}

