/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.concepts.majordomo;

import io.opencmw.concepts.majordomo.MajordomoProtocol;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class MajordomoClientV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajordomoClientV2.class);
    private final String broker;
    private final ZContext ctx;
    private ZMQ.Socket clientSocket;
    private long timeout = 2500L;
    private ZMQ.Poller poller;

    public MajordomoClientV2(String broker) {
        this.broker = broker;
        this.ctx = new ZContext();
        this.reconnectToBroker();
    }

    public void destroy() {
        this.ctx.destroy();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ZMsg recv() {
        if (this.poller.poll(this.timeout * 1000L) == -1) {
            return null;
        }
        if (this.poller.pollin(0)) {
            ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)this.clientSocket);
            LOGGER.atDebug().addArgument((Object)msg).log("received reply: '{}'");
            assert (msg.size() >= 4);
            ZFrame empty = msg.pop();
            assert (empty.getData().length == 0);
            empty.destroy();
            ZFrame header = msg.pop();
            assert (MajordomoProtocol.MdpSubProtocol.C_CLIENT.isEquals(header.getData()));
            header.destroy();
            ZFrame replyService = msg.pop();
            replyService.destroy();
            return msg;
        }
        return null;
    }

    public boolean send(byte[] service, byte[] ... msgs) {
        return MajordomoProtocol.sendClientMessage(this.clientSocket, MajordomoProtocol.MdpClientCommand.C_UNKNOWN, null, service, msgs);
    }

    public boolean send(String service, byte[] ... msgs) {
        return this.send(service.getBytes(StandardCharsets.UTF_8), msgs);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void reconnectToBroker() {
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        this.clientSocket = this.ctx.createSocket(SocketType.DEALER);
        this.clientSocket.setHWM(0);
        this.clientSocket.setIdentity("clientV2".getBytes(StandardCharsets.UTF_8));
        this.clientSocket.connect(this.broker);
        if (this.poller != null) {
            this.poller.unregister(this.clientSocket);
            this.poller.close();
        }
        this.poller = this.ctx.createPoller(1);
        this.poller.register(this.clientSocket, 1);
        LOGGER.atDebug().addArgument((Object)this.broker).log("connecting to broker at: '{}'");
    }
}

