/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.concepts.majordomo;

import io.opencmw.concepts.majordomo.MajordomoProtocol;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import org.zeromq.util.ZData;

public class MajordomoClientV1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(MajordomoClientV1.class);
    private static final AtomicInteger CLIENT_V1_INSTANCE = new AtomicInteger();
    private final String uniqueID;
    private final byte[] uniqueIdBytes;
    private final String broker;
    private final ZContext ctx;
    private ZMQ.Socket clientSocket;
    private long timeout = 2500L;
    private int retries = 3;
    private final Formatter log = new Formatter(System.out);
    private ZMQ.Poller poller;

    public MajordomoClientV1(String broker, String clientName) {
        this.broker = broker;
        this.ctx = new ZContext();
        this.uniqueID = clientName + "PID=" + ManagementFactory.getRuntimeMXBean().getName() + "-InstanceID=" + CLIENT_V1_INSTANCE.getAndIncrement();
        this.uniqueIdBytes = this.uniqueID.getBytes(ZMQ.CHARSET);
        this.reconnectToBroker();
    }

    private void reconnectToBroker() {
        if (this.clientSocket != null) {
            this.clientSocket.close();
        }
        this.clientSocket = this.ctx.createSocket(SocketType.DEALER);
        this.clientSocket.setHWM(0);
        this.clientSocket.setIdentity(this.uniqueIdBytes);
        this.clientSocket.connect(this.broker);
        if (this.poller != null) {
            this.poller.unregister(this.clientSocket);
            this.poller.close();
        }
        this.poller = this.ctx.createPoller(1);
        this.poller.register(this.clientSocket, 1);
        LOGGER.atDebug().addArgument((Object)this.broker).log("connecting to broker at: '{}'");
    }

    public void destroy() {
        this.ctx.destroy();
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public ZMsg send(String service, byte[] ... msgs) {
        return this.send(service.getBytes(StandardCharsets.UTF_8), msgs);
    }

    public ZMsg send(byte[] service, byte[] ... msgs) {
        ZMsg reply = null;
        int retriesLeft = this.retries;
        while (retriesLeft > 0 && !Thread.currentThread().isInterrupted()) {
            if (!MajordomoProtocol.sendClientMessage(this.clientSocket, MajordomoProtocol.MdpClientCommand.C_UNKNOWN, null, service, msgs)) {
                throw new IllegalStateException("could not send request " + Arrays.stream(msgs).map(ZData::toString).collect(Collectors.joining(",", "[", "]")));
            }
            if (this.poller.poll(this.timeout) == -1) break;
            if (this.poller.pollin(0)) {
                ZMsg msg = ZMsg.recvMsg((ZMQ.Socket)this.clientSocket, (boolean)false);
                LOGGER.atDebug().addArgument((Object)msg).log("received reply: '{}'");
                if (msg == null) break;
                assert (msg.size() >= 3);
                ZFrame emptyFrame = msg.pop();
                assert (emptyFrame.size() == 0);
                ZFrame header = msg.pop();
                assert (MajordomoProtocol.MdpSubProtocol.C_CLIENT.isEquals(header.getData()));
                header.destroy();
                ZFrame replyService = msg.pop();
                assert (Arrays.equals(service, replyService.getData()));
                replyService.destroy();
                reply = msg;
                break;
            }
            if (--retriesLeft == 0) {
                this.log.format("W: permanent error, abandoning\n", new Object[0]);
                break;
            }
            this.log.format("W: no reply, reconnecting\n", new Object[0]);
            this.reconnectToBroker();
        }
        return reply;
    }
}

