/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.concepts.aggregate;

import com.lmax.disruptor.RingBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.LockSupport;

public class TestEventSource
implements Runnable {
    private static final int DEFAULT_CHAIN = 3;
    private static final long DEFAULT_DELTA = 20L;
    private static final long DEFAULT_PAUSE = 400L;
    public final int repeat;
    public final String[] eventList;
    private final RingBuffer<IngestedEvent> ringBuffer;

    public TestEventSource(String events, int repeat, RingBuffer<IngestedEvent> rb) {
        this.eventList = events.split(" ");
        this.repeat = repeat;
        this.ringBuffer = rb;
    }

    @Override
    public void run() {
        long lastEvent = System.currentTimeMillis();
        long timeOffset = 0L;
        for (int repetitionCount = 0; this.repeat == 0 || this.repeat > repetitionCount; ++repetitionCount) {
            Iterator eventIterator = Arrays.stream(this.eventList).iterator();
            while (!Thread.interrupted() && eventIterator.hasNext()) {
                String eventToken = (String)eventIterator.next();
                String[] tokens = eventToken.split(";");
                if (tokens.length == 0 || tokens[0].isEmpty()) continue;
                if ("pause".equals(tokens[0])) {
                    lastEvent += 400L;
                    continue;
                }
                Event currentEvent = this.generateEventFromToken(tokens, timeOffset, lastEvent, repetitionCount);
                lastEvent = currentEvent.publishTime;
                long diff = currentEvent.publishTime - System.currentTimeMillis();
                if (diff > 0L) {
                    LockSupport.parkNanos(1000000L * diff);
                }
                this.ringBuffer.publishEvent((event, sequence, arg0) -> {
                    event.ingestionTime = System.currentTimeMillis();
                    event.payload = arg0;
                }, (Object)currentEvent);
            }
        }
    }

    private Event generateEventFromToken(String[] tokens, long timeOffset, long lastEvent, int repetitionCount) {
        long sourceTime;
        String device = tokens[0].substring(0, 1);
        long bpcts = Long.parseLong(tokens[0].substring(1)) + (long)repetitionCount * 1000L;
        int type = device.charAt(0);
        String payload = device + bpcts;
        long publishTime = sourceTime = lastEvent + 20L;
        int chain = 3;
        block20: for (int i = 1; i < tokens.length; ++i) {
            Object[] keyvalue = tokens[i].split("=");
            if (keyvalue.length != 2) continue;
            switch (keyvalue[0]) {
                case "time": {
                    publishTime = sourceTime = Long.parseLong(keyvalue[1]) + timeOffset;
                    continue block20;
                }
                case "sourceTime": {
                    sourceTime = Long.parseLong(keyvalue[1]) + timeOffset;
                    continue block20;
                }
                case "publishTime": {
                    publishTime = Long.parseLong(keyvalue[1]) + timeOffset;
                    continue block20;
                }
                case "bpcts": {
                    bpcts = Long.parseLong(keyvalue[1]) + (long)repetitionCount * 1000L;
                    continue block20;
                }
                case "chain": {
                    chain = Integer.parseInt(keyvalue[1]);
                    continue block20;
                }
                case "type": {
                    type = Integer.parseInt(keyvalue[1]);
                    continue block20;
                }
                case "device": {
                    device = keyvalue[1];
                    continue block20;
                }
                case "payload": {
                    payload = keyvalue[1] + "(repetition count: " + repetitionCount + ")";
                    continue block20;
                }
                default: {
                    throw new IllegalArgumentException("unable to process event keyvalue pair: " + Arrays.toString(keyvalue));
                }
            }
        }
        return new Event(sourceTime, publishTime, bpcts, chain, type, device, payload);
    }

    public static class IngestedEvent {
        public long ingestionTime;
        public Object payload;

        public String toString() {
            return "IngestedEvent{ingestionTime=" + this.ingestionTime + ", payload=" + this.payload + "}";
        }
    }

    public static class Event {
        public final long sourceTime;
        public final long publishTime;
        public final long bpcts;
        public final int chain;
        public final int type;
        public final String device;
        public final Object payload;

        public Event(long sourceTime, long publishTime, long bpcts, int chain, int type, String device, Object payload) {
            this.sourceTime = sourceTime;
            this.publishTime = publishTime;
            this.bpcts = bpcts;
            this.chain = chain;
            this.type = type;
            this.device = device;
            this.payload = payload;
        }

        public String toString() {
            return "Event{sourceTime=" + this.sourceTime + ", publishTime=" + this.publishTime + ", bpcts=" + this.bpcts + ", chain=" + this.chain + ", type=" + this.type + ", device='" + this.device + "', payload=" + this.payload + "}";
        }
    }
}

