/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client.cmwlight;

import io.opencmw.OpenCmwConstants;
import io.opencmw.client.DnsResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DirectoryLightClient
implements DnsResolver {
    public static final String GET_DEVICE_INFO = "get-device-info";
    private static final String ERROR_STRING = "ERROR";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String NOT_BOUND_LOCATION = "*NOT_BOUND*";
    private static final String CLIENT_INFO = "DirectoryLightClient";
    private static final String VERSION = "2.0.0";
    private final String nameserver;
    private final int nameserverPort;

    public DirectoryLightClient(String ... nameservers) {
        if (nameservers.length != 1) {
            throw new IllegalArgumentException("only one nameserver supported at the moment");
        }
        String[] hostPort = nameservers[0].split(HOST_PORT_SEPARATOR);
        if (hostPort.length != 2) {
            throw new IllegalArgumentException("nameserver address has wrong format: " + nameservers[0]);
        }
        this.nameserver = hostPort[0];
        this.nameserverPort = Integer.parseInt(hostPort[1]);
    }

    @Override
    public void close() {
    }

    @Override
    public List<String> getApplicableSchemes() {
        return List.of("rda3");
    }

    @Override
    public Map<URI, List<URI>> resolveNames(List<URI> devicesToResolve) throws UnknownHostException {
        List<String> deviceList = devicesToResolve.stream().map(OpenCmwConstants::getDeviceName).collect(Collectors.toList());
        try {
            List<Device> deviceInfos = this.getDeviceInfo(deviceList);
            ConcurrentHashMap<URI, List<URI>> map = new ConcurrentHashMap<URI, List<URI>>();
            for (Device device : deviceInfos) {
                map.put(URI.create("rda3:/" + device.name), List.of(URI.create(device.getAddress())));
            }
            return map;
        }
        catch (Exception e) {
            throw new UnknownHostException("resolveNames : " + e.getMessage());
        }
    }

    private String getDeviceMsg(List<String> devices) {
        StringBuilder sb = new StringBuilder();
        sb.append(GET_DEVICE_INFO).append("\n@client-info ").append(CLIENT_INFO).append("\n@version ").append(VERSION).append('\n');
        for (String dev : devices) {
            sb.append(dev).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public List<Device> getDeviceInfo(List<String> devices) throws DirectoryClientException {
        ArrayList<Device> result = new ArrayList<Device>();
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(this.nameserver, this.nameserverPort));
            try (PrintWriter writer = new PrintWriter(socket.getOutputStream());
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));){
                String line;
                writer.write(this.getDeviceMsg(devices));
                writer.flush();
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.equals(ERROR_STRING)) {
                        String errorMsg = bufferedReader.lines().collect(Collectors.joining("\n")).strip();
                        throw new DirectoryClientException(errorMsg);
                    }
                    result.add(this.parseDeviceInfo(line));
                }
            }
        }
        catch (IOException e) {
            throw new DirectoryClientException("Nameserver error: ", e);
        }
        return result;
    }

    private Device parseDeviceInfo(String line) throws DirectoryClientException {
        String[] tokens = line.split(" ");
        if (tokens.length < 2) {
            throw new DirectoryClientException("Malformed reply line: " + line);
        }
        if (tokens[1].equals(NOT_BOUND_LOCATION)) {
            throw new DirectoryClientException("Requested device not bound: " + tokens[0]);
        }
        ArrayList<Map<String, String>> servers = new ArrayList<Map<String, String>>();
        for (int j = 2; j < tokens.length; ++j) {
            HashMap<Object, String> server = new HashMap<Object, String>();
            servers.add(server);
            Object[] servertokens = tokens[j].split("#");
            server.put("protocol", servertokens[0]);
            int k = 1;
            while (k + 3 < servertokens.length) {
                if ("string".equals(servertokens[k + 1])) {
                    String value;
                    int length = Integer.parseInt(servertokens[k + 2]);
                    if (length != (value = URLDecoder.decode(servertokens[k + 3], Charset.defaultCharset())).length()) {
                        throw new DirectoryClientException("Error parsing string: " + (String)servertokens[k] + "(" + length + ") = " + value);
                    }
                    server.put(servertokens[k], value);
                    k += 4;
                    continue;
                }
                if ("int".equals(servertokens[k + 1]) || "long".equals(servertokens[k + 1])) {
                    server.put(servertokens[k], servertokens[k + 2]);
                    k += 3;
                    continue;
                }
                throw new DirectoryClientException("Error parsing argument: " + k + ": " + Arrays.toString(servertokens));
            }
        }
        return new Device(tokens[0], tokens[1], servers);
    }

    public static class DirectoryClientException
    extends Exception {
        private static final long serialVersionUID = -4452775634393421952L;

        public DirectoryClientException(String errorMsg) {
            super(errorMsg);
        }

        public DirectoryClientException(String errorMsg, Exception cause) {
            super(errorMsg, cause);
        }
    }

    public static class Device {
        public final String name;
        private final String deviceClass;
        public final List<Map<String, String>> servers;

        public Device(String name, String deviceClass, List<Map<String, String>> servers) {
            this.name = name;
            this.deviceClass = deviceClass;
            this.servers = servers;
        }

        public String toString() {
            return "Device{name='" + this.name + "', deviceClass='" + this.deviceClass + "', servers=" + this.servers + "}";
        }

        public String getAddress() {
            return this.servers.stream().filter(s -> "rda3://9".equals(s.get("protocol"))).map(s -> (String)s.get("Address:")).findFirst().orElseThrow();
        }
    }
}

