/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client.cmwlight;

import io.opencmw.client.cmwlight.CmwLightMessage;
import io.opencmw.serialiser.DataType;
import io.opencmw.serialiser.FieldDescription;
import io.opencmw.serialiser.IoBuffer;
import io.opencmw.serialiser.IoClassSerialiser;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.spi.CmwLightSerialiser;
import io.opencmw.serialiser.spi.FastByteBuffer;
import io.opencmw.serialiser.spi.WireDataFieldDescription;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class CmwLightProtocol {
    private static final String CONTEXT_ACQ_STAMP = "ContextAcqStamp";
    private static final String CONTEXT_CYCLE_STAMP = "ContextCycleStamp";
    private static final String MESSAGE = "Message";
    private static final String TYPE = "Type";
    private static final String EMPTY_CONTEXT = "empty context data for request type: ";
    private static final int MAX_MSG_SIZE = 0x400000;
    private static final IoBuffer IO_BUFFER = new FastByteBuffer(0x400000);
    private static final CmwLightSerialiser SERIALISER = new CmwLightSerialiser(IO_BUFFER);
    private static final IoClassSerialiser IO_CLASS_SERIALISER = new IoClassSerialiser(IO_BUFFER, new Class[0]);
    public static final String VERSION = "1.0.0";
    private static final int SERIALISER_QUIRK = 100;

    private CmwLightProtocol() {
    }

    public static CmwLightMessage recvMsg(ZMQ.Socket socket, int tout) throws RdaLightException {
        return CmwLightProtocol.parseMsg(ZMsg.recvMsg((ZMQ.Socket)socket, (int)tout));
    }

    public static CmwLightMessage parseMsg(@NotNull ZMsg data) throws RdaLightException {
        ZFrame firstFrame = data.pollFirst();
        if (firstFrame != null && Arrays.equals(firstFrame.getData(), new byte[]{MessageType.SERVER_CONNECT_ACK.value()})) {
            CmwLightMessage reply = new CmwLightMessage(MessageType.SERVER_CONNECT_ACK);
            ZFrame versionData = data.pollFirst();
            assert (versionData != null) : "version data in connection acknowledgement frame";
            reply.version = versionData.getString(Charset.defaultCharset());
            return reply;
        }
        if (firstFrame != null && Arrays.equals(firstFrame.getData(), new byte[]{MessageType.CLIENT_CONNECT.value()})) {
            CmwLightMessage reply = new CmwLightMessage(MessageType.CLIENT_CONNECT);
            ZFrame versionData = data.pollFirst();
            assert (versionData != null) : "version data in connection acknowledgement frame";
            reply.version = versionData.getString(Charset.defaultCharset());
            return reply;
        }
        if (firstFrame != null && Arrays.equals(firstFrame.getData(), new byte[]{MessageType.SERVER_HB.value()})) {
            return CmwLightMessage.SERVER_HB;
        }
        if (firstFrame != null && Arrays.equals(firstFrame.getData(), new byte[]{MessageType.CLIENT_HB.value()})) {
            return CmwLightMessage.CLIENT_HB;
        }
        byte[] descriptor = CmwLightProtocol.checkDescriptor(data.pollLast(), firstFrame);
        ZFrame headerMsg = data.poll();
        assert (headerMsg != null) : "message header";
        CmwLightMessage reply = CmwLightProtocol.getReplyFromHeader(firstFrame, headerMsg);
        switch (reply.requestType) {
            case REPLY: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY, FrameType.BODY_DATA_CONTEXT);
                reply.bodyData = data.pollFirst();
                if (data.isEmpty()) {
                    throw new RdaLightException(EMPTY_CONTEXT + reply.requestType);
                }
                reply.dataContext = CmwLightProtocol.parseContextData(data.pollFirst());
                return reply;
            }
            case NOTIFICATION_DATA: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY, FrameType.BODY_DATA_CONTEXT);
                if (reply.options != null && reply.options.containsKey(FieldName.NOTIFICATION_ID_TAG.value())) {
                    reply.notificationId = (Long)reply.options.get(FieldName.NOTIFICATION_ID_TAG.value());
                }
                reply.bodyData = data.pollFirst();
                if (data.isEmpty()) {
                    throw new RdaLightException(EMPTY_CONTEXT + reply.requestType);
                }
                reply.dataContext = CmwLightProtocol.parseContextData(data.pollFirst());
                return reply;
            }
            case EXCEPTION: 
            case NOTIFICATION_EXC: 
            case SUBSCRIBE_EXCEPTION: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY_EXCEPTION);
                reply.exceptionMessage = CmwLightProtocol.parseExceptionMessage(data.pollFirst());
                return reply;
            }
            case GET: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY_REQUEST_CONTEXT);
                if (data.isEmpty()) {
                    throw new RdaLightException(EMPTY_CONTEXT + reply.requestType);
                }
                reply.requestContext = CmwLightProtocol.parseRequestContext(data.pollFirst());
                return reply;
            }
            case SUBSCRIBE: {
                if (reply.messageType == MessageType.SERVER_REP) {
                    CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER);
                    if (reply.options != null && reply.options.containsKey(FieldName.SOURCE_ID_TAG.value())) {
                        reply.sourceId = (Long)reply.options.get(FieldName.SOURCE_ID_TAG.value());
                    }
                } else {
                    CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY_REQUEST_CONTEXT);
                    if (data.isEmpty()) {
                        throw new RdaLightException(EMPTY_CONTEXT + reply.requestType);
                    }
                    reply.requestContext = CmwLightProtocol.parseRequestContext(data.pollFirst());
                }
                return reply;
            }
            case SESSION_CONFIRM: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER);
                if (reply.options != null && reply.options.containsKey(FieldName.SESSION_BODY_TAG.value())) {
                    Object subMap = reply.options.get(FieldName.SESSION_BODY_TAG.value());
                    if (subMap == null) {
                        return reply;
                    }
                    String fieldName = FieldName.SESSION_BODY_TAG.value();
                    if (subMap instanceof Map) {
                        Map castMap;
                        reply.sessionBody = castMap = (Map)reply.options.get(fieldName);
                    } else {
                        throw new RdaLightException("field member '" + fieldName + "' not assignable to Map<String, Object>: " + subMap);
                    }
                }
                return reply;
            }
            case EVENT: 
            case UNSUBSCRIBE: 
            case CONNECT: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER);
                return reply;
            }
            case SET: {
                CmwLightProtocol.assertDescriptor(descriptor, FrameType.HEADER, FrameType.BODY, FrameType.BODY_REQUEST_CONTEXT);
                reply.bodyData = data.pollFirst();
                if (data.isEmpty()) {
                    throw new RdaLightException(EMPTY_CONTEXT + reply.requestType);
                }
                reply.requestContext = CmwLightProtocol.parseRequestContext(data.pollFirst());
                return reply;
            }
        }
        throw new RdaLightException("received unknown or non-client request type: " + reply.requestType);
    }

    public static boolean sendMsg(ZMQ.Socket socket, CmwLightMessage msg) throws RdaLightException {
        return CmwLightProtocol.serialiseMsg(msg).send(socket);
    }

    public static ZMsg serialiseMsg(CmwLightMessage msg) throws RdaLightException {
        ZMsg result = new ZMsg();
        switch (msg.messageType) {
            case SERVER_CONNECT_ACK: 
            case CLIENT_CONNECT: {
                result.add(new ZFrame(new byte[]{msg.messageType.value()}));
                result.add(new ZFrame(msg.version == null || msg.version.isEmpty() ? VERSION : msg.version));
                return result;
            }
            case CLIENT_HB: 
            case SERVER_HB: {
                result.add(new ZFrame(new byte[]{msg.messageType.value()}));
                return result;
            }
            case SERVER_REP: 
            case CLIENT_REQ: {
                result.add(new byte[]{msg.messageType.value()});
                result.add(CmwLightProtocol.serialiseHeader(msg));
                switch (msg.requestType) {
                    case SESSION_CONFIRM: 
                    case EVENT: 
                    case UNSUBSCRIBE: 
                    case CONNECT: {
                        CmwLightProtocol.addDescriptor(result, FrameType.HEADER);
                        break;
                    }
                    case GET: 
                    case SUBSCRIBE: {
                        if (msg.messageType == MessageType.CLIENT_REQ) {
                            assert (msg.requestContext != null) : "requestContext";
                            result.add(CmwLightProtocol.serialiseRequestContext(msg.requestContext));
                            CmwLightProtocol.addDescriptor(result, FrameType.HEADER, FrameType.BODY_REQUEST_CONTEXT);
                            break;
                        }
                        CmwLightProtocol.addDescriptor(result, FrameType.HEADER);
                        break;
                    }
                    case SET: {
                        assert (msg.bodyData != null) : "bodyData";
                        assert (msg.requestContext != null) : "requestContext";
                        result.add(msg.bodyData);
                        result.add(CmwLightProtocol.serialiseRequestContext(msg.requestContext));
                        CmwLightProtocol.addDescriptor(result, FrameType.HEADER, FrameType.BODY, FrameType.BODY_REQUEST_CONTEXT);
                        break;
                    }
                    case REPLY: 
                    case NOTIFICATION_DATA: {
                        assert (msg.bodyData != null) : "bodyData";
                        result.add(msg.bodyData);
                        result.add(CmwLightProtocol.serialiseDataContext(msg.dataContext));
                        CmwLightProtocol.addDescriptor(result, FrameType.HEADER, FrameType.BODY, FrameType.BODY_DATA_CONTEXT);
                        break;
                    }
                    case EXCEPTION: 
                    case NOTIFICATION_EXC: 
                    case SUBSCRIBE_EXCEPTION: {
                        assert (msg.exceptionMessage != null) : "exceptionMessage";
                        result.add(CmwLightProtocol.serialiseExceptionMessage(msg.exceptionMessage));
                        CmwLightProtocol.addDescriptor(result, FrameType.HEADER, FrameType.BODY_EXCEPTION);
                        break;
                    }
                }
                return result;
            }
        }
        throw new RdaLightException("Invalid cmwMessage: " + msg);
    }

    private static ZFrame serialiseExceptionMessage(CmwLightMessage.ExceptionMessage exceptionMessage) {
        IO_BUFFER.reset();
        SERIALISER.setBuffer(IO_BUFFER);
        SERIALISER.putHeaderInfo(new FieldDescription[0]);
        SERIALISER.put(CONTEXT_ACQ_STAMP, exceptionMessage.contextAcqStamp);
        SERIALISER.put(CONTEXT_CYCLE_STAMP, exceptionMessage.contextCycleStamp);
        SERIALISER.put(MESSAGE, exceptionMessage.message);
        SERIALISER.put(TYPE, exceptionMessage.type);
        IO_BUFFER.flip();
        return new ZFrame(Arrays.copyOfRange(IO_BUFFER.elements(), 0, IO_BUFFER.limit() + 100));
    }

    private static void addDescriptor(ZMsg result, FrameType ... frametypes) {
        byte[] descriptor = new byte[frametypes.length];
        for (int i = 0; i < descriptor.length; ++i) {
            descriptor[i] = frametypes[i].value();
        }
        result.add(new ZFrame(descriptor));
    }

    private static ZFrame serialiseHeader(CmwLightMessage msg) throws RdaLightException {
        IO_BUFFER.reset();
        SERIALISER.setBuffer(IO_BUFFER);
        SERIALISER.putHeaderInfo(new FieldDescription[0]);
        SERIALISER.put(FieldName.REQ_TYPE_TAG.value(), msg.requestType.value());
        SERIALISER.put(FieldName.ID_TAG.value(), msg.id);
        SERIALISER.put(FieldName.DEVICE_NAME_TAG.value(), msg.deviceName);
        SERIALISER.put(FieldName.PROPERTY_NAME_TAG.value(), msg.propertyName);
        if (msg.updateType != null) {
            SERIALISER.put(FieldName.UPDATE_TYPE_TAG.value(), msg.updateType.value());
        }
        SERIALISER.put(FieldName.SESSION_ID_TAG.value(), msg.sessionId);
        CmwLightProtocol.putMap(SERIALISER, FieldName.OPTIONS_TAG.value(), msg.options);
        IO_BUFFER.flip();
        return new ZFrame(Arrays.copyOfRange(IO_BUFFER.elements(), 0, IO_BUFFER.limit() + 100));
    }

    private static ZFrame serialiseRequestContext(CmwLightMessage.RequestContext requestContext) throws RdaLightException {
        IO_BUFFER.reset();
        SERIALISER.putHeaderInfo(new FieldDescription[0]);
        SERIALISER.put(FieldName.SELECTOR_TAG.value(), requestContext.selector);
        CmwLightProtocol.putMap(SERIALISER, FieldName.FILTERS_TAG.value(), requestContext.filters);
        CmwLightProtocol.putMap(SERIALISER, FieldName.DATA_TAG.value(), requestContext.data);
        IO_BUFFER.flip();
        return new ZFrame(Arrays.copyOfRange(IO_BUFFER.elements(), 0, IO_BUFFER.limit() + 100));
    }

    private static ZFrame serialiseDataContext(CmwLightMessage.DataContext dataContext) throws RdaLightException {
        IO_BUFFER.reset();
        SERIALISER.putHeaderInfo(new FieldDescription[0]);
        SERIALISER.put(FieldName.CYCLE_NAME_TAG.value(), dataContext.cycleName);
        SERIALISER.put(FieldName.CYCLE_STAMP_TAG.value(), dataContext.cycleStamp);
        SERIALISER.put(FieldName.ACQ_STAMP_TAG.value(), dataContext.acqStamp);
        CmwLightProtocol.putMap(SERIALISER, FieldName.DATA_TAG.value(), dataContext.data);
        IO_BUFFER.flip();
        return new ZFrame(Arrays.copyOfRange(IO_BUFFER.elements(), 0, IO_BUFFER.limit() + 100));
    }

    private static void putMap(CmwLightSerialiser serialiser, String fieldName, Map<String, Object> map) throws RdaLightException {
        if (map != null) {
            WireDataFieldDescription dataFieldMarker = new WireDataFieldDescription((IoSerialiser)serialiser, (FieldDescription)serialiser.getParent(), -1, fieldName, DataType.START_MARKER, -1, -1, -1);
            serialiser.putStartMarker((FieldDescription)dataFieldMarker);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof String) {
                    serialiser.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof Integer) {
                    serialiser.put(entry.getKey(), ((Integer)entry.getValue()).intValue());
                    continue;
                }
                if (entry.getValue() instanceof Long) {
                    serialiser.put(entry.getKey(), ((Long)entry.getValue()).longValue());
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    serialiser.put(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    continue;
                }
                if (entry.getValue() instanceof Map) {
                    Map subMap = (Map)entry.getValue();
                    CmwLightProtocol.putMap(serialiser, entry.getKey(), subMap);
                    continue;
                }
                throw new RdaLightException("unsupported map entry type: " + entry.getValue().getClass().getCanonicalName());
            }
            serialiser.putEndMarker((FieldDescription)dataFieldMarker);
        }
    }

    private static CmwLightMessage getReplyFromHeader(ZFrame firstFrame, ZFrame header) throws RdaLightException {
        CmwLightMessage reply = new CmwLightMessage(MessageType.of(firstFrame.getData()[0]));
        IO_CLASS_SERIALISER.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])header.getData()));
        try {
            FieldDescription headerMap = (FieldDescription)IO_CLASS_SERIALISER.parseWireFormat().getChildren().get(0);
            for (FieldDescription field : headerMap.getChildren()) {
                if (field.getFieldName().equals(FieldName.REQ_TYPE_TAG.value()) && field.getType() == Byte.TYPE) {
                    reply.requestType = RequestType.of(((Byte)((WireDataFieldDescription)field).data(new DataType[0])).byteValue());
                    continue;
                }
                if (field.getFieldName().equals(FieldName.ID_TAG.value()) && field.getType() == Long.TYPE) {
                    reply.id = (Long)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.DEVICE_NAME_TAG.value()) && field.getType() == String.class) {
                    reply.deviceName = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.OPTIONS_TAG.value())) {
                    reply.options = CmwLightProtocol.readMap(field);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.UPDATE_TYPE_TAG.value()) && field.getType() == Byte.TYPE) {
                    reply.updateType = UpdateType.of(((Byte)((WireDataFieldDescription)field).data(new DataType[0])).byteValue());
                    continue;
                }
                if (field.getFieldName().equals(FieldName.SESSION_ID_TAG.value()) && field.getType() == String.class) {
                    reply.sessionId = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.PROPERTY_NAME_TAG.value()) && field.getType() == String.class) {
                    reply.propertyName = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                throw new RdaLightException("Unknown CMW header field: " + field.getFieldName());
            }
        }
        catch (IllegalStateException e) {
            throw new RdaLightException("unparsable header: " + Arrays.toString(header.getData()) + "(" + header.toString() + ")", e);
        }
        if (reply.requestType == null) {
            throw new RdaLightException("Header does not contain request type field");
        }
        return reply;
    }

    private static Map<String, Object> readMap(FieldDescription field) {
        HashMap<String, Object> result = null;
        for (FieldDescription dataField : field.getChildren()) {
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            result.put(dataField.getFieldName(), ((WireDataFieldDescription)dataField).data(new DataType[0]));
        }
        return result;
    }

    private static CmwLightMessage.ExceptionMessage parseExceptionMessage(ZFrame exceptionBody) throws RdaLightException {
        if (exceptionBody == null) {
            throw new RdaLightException("malformed subscription exception");
        }
        CmwLightMessage.ExceptionMessage exceptionMessage = new CmwLightMessage.ExceptionMessage();
        IO_CLASS_SERIALISER.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])exceptionBody.getData()));
        FieldDescription exceptionFields = (FieldDescription)IO_CLASS_SERIALISER.parseWireFormat().getChildren().get(0);
        for (FieldDescription field : exceptionFields.getChildren()) {
            if (CONTEXT_ACQ_STAMP.equals(field.getFieldName()) && field.getType() == Long.TYPE) {
                exceptionMessage.contextAcqStamp = (Long)((WireDataFieldDescription)field).data(new DataType[0]);
                continue;
            }
            if (CONTEXT_CYCLE_STAMP.equals(field.getFieldName()) && field.getType() == Long.TYPE) {
                exceptionMessage.contextCycleStamp = (Long)((WireDataFieldDescription)field).data(new DataType[0]);
                continue;
            }
            if (MESSAGE.equals(field.getFieldName()) && field.getType() == String.class) {
                exceptionMessage.message = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                continue;
            }
            if (TYPE.equals(field.getFieldName()) && field.getType() == Byte.TYPE) {
                exceptionMessage.type = (Byte)((WireDataFieldDescription)field).data(new DataType[0]);
                continue;
            }
            throw new RdaLightException("Unsupported field in exception body: " + field.getFieldName());
        }
        return exceptionMessage;
    }

    private static CmwLightMessage.RequestContext parseRequestContext(@NotNull ZFrame contextData) throws RdaLightException {
        CmwLightMessage.RequestContext requestContext = new CmwLightMessage.RequestContext();
        IO_CLASS_SERIALISER.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])contextData.getData()));
        try {
            FieldDescription contextMap = (FieldDescription)IO_CLASS_SERIALISER.parseWireFormat().getChildren().get(0);
            for (FieldDescription field : contextMap.getChildren()) {
                if (field.getFieldName().equals(FieldName.SELECTOR_TAG.value()) && field.getType() == String.class) {
                    requestContext.selector = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.FILTERS_TAG.value())) {
                    for (FieldDescription dataField : field.getChildren()) {
                        if (requestContext.filters == null) {
                            requestContext.filters = new HashMap<String, Object>();
                        }
                        requestContext.filters.put(dataField.getFieldName(), ((WireDataFieldDescription)dataField).data(new DataType[0]));
                    }
                    continue;
                }
                if (field.getFieldName().equals(FieldName.DATA_TAG.value())) {
                    for (FieldDescription dataField : field.getChildren()) {
                        if (requestContext.data == null) {
                            requestContext.data = new HashMap<String, Object>();
                        }
                        requestContext.data.put(dataField.getFieldName(), ((WireDataFieldDescription)dataField).data(new DataType[0]));
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Unknown field: " + field.getFieldName());
            }
        }
        catch (IllegalStateException e) {
            throw new RdaLightException("unparsable context data: " + Arrays.toString(contextData.getData()) + "(" + new String(contextData.getData()) + ")", e);
        }
        return requestContext;
    }

    private static CmwLightMessage.DataContext parseContextData(@NotNull ZFrame contextData) throws RdaLightException {
        CmwLightMessage.DataContext dataContext = new CmwLightMessage.DataContext();
        IO_CLASS_SERIALISER.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])contextData.getData()));
        try {
            FieldDescription contextMap = (FieldDescription)IO_CLASS_SERIALISER.parseWireFormat().getChildren().get(0);
            for (FieldDescription field : contextMap.getChildren()) {
                if (field.getFieldName().equals(FieldName.CYCLE_NAME_TAG.value()) && field.getType() == String.class) {
                    dataContext.cycleName = (String)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.ACQ_STAMP_TAG.value()) && field.getType() == Long.TYPE) {
                    dataContext.acqStamp = (Long)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.CYCLE_STAMP_TAG.value()) && field.getType() == Long.TYPE) {
                    dataContext.cycleStamp = (Long)((WireDataFieldDescription)field).data(new DataType[0]);
                    continue;
                }
                if (field.getFieldName().equals(FieldName.DATA_TAG.value())) {
                    for (FieldDescription dataField : field.getChildren()) {
                        if (dataContext.data == null) {
                            dataContext.data = new HashMap<String, Object>();
                        }
                        dataContext.data.put(dataField.getFieldName(), ((WireDataFieldDescription)dataField).data(new DataType[0]));
                    }
                    continue;
                }
                throw new UnsupportedOperationException("Unknown field: " + field.getFieldName());
            }
        }
        catch (IllegalStateException e) {
            throw new RdaLightException("unparsable context data: " + Arrays.toString(contextData.getData()) + "(" + new String(contextData.getData()) + ")", e);
        }
        return dataContext;
    }

    private static void assertDescriptor(byte[] descriptor, FrameType ... frameTypes) throws RdaLightException {
        if (descriptor.length != frameTypes.length) {
            throw new RdaLightException("descriptor does not match message type: \n  " + Arrays.toString(descriptor) + "\n  " + Arrays.toString((Object[])frameTypes));
        }
        for (int i = 1; i < descriptor.length; ++i) {
            if (descriptor[i] == frameTypes[i].value()) continue;
            throw new RdaLightException("descriptor does not match message type: \n  " + Arrays.toString(descriptor) + "\n  " + Arrays.toString((Object[])frameTypes));
        }
    }

    private static byte[] checkDescriptor(ZFrame descriptorMsg, ZFrame firstFrame) throws RdaLightException {
        if (firstFrame == null || !Arrays.equals(firstFrame.getData(), new byte[]{MessageType.SERVER_REP.value()}) && !Arrays.equals(firstFrame.getData(), new byte[]{MessageType.CLIENT_REQ.value()})) {
            throw new RdaLightException("Expecting only messages of type Heartbeat or Reply but got: " + firstFrame);
        }
        if (descriptorMsg == null) {
            throw new RdaLightException("Message does not contain descriptor");
        }
        byte[] descriptor = descriptorMsg.getData();
        if (descriptor[0] != FrameType.HEADER.value()) {
            throw new RdaLightException("First message of SERVER_REP has to be of type MT_HEADER but is: " + descriptor[0]);
        }
        return descriptor;
    }

    public static class RdaLightException
    extends Exception {
        private static final long serialVersionUID = 5197623305559702319L;

        public RdaLightException(String msg) {
            super(msg);
        }

        public RdaLightException(String msg, Throwable e) {
            super(msg, e);
        }
    }

    public static enum UpdateType {
        NORMAL(0),
        FIRST_UPDATE(1),
        IMMEDIATE_UPDATE(2);

        private final byte value;

        private UpdateType(int value) {
            this.value = (byte)value;
        }

        public static UpdateType of(int value) {
            return UpdateType.values()[value];
        }

        public byte value() {
            return this.value;
        }
    }

    public static enum RequestType {
        GET(0),
        SET(1),
        CONNECT(2),
        REPLY(3),
        EXCEPTION(4),
        SUBSCRIBE(5),
        UNSUBSCRIBE(6),
        NOTIFICATION_DATA(7),
        NOTIFICATION_EXC(8),
        SUBSCRIBE_EXCEPTION(9),
        EVENT(10),
        SESSION_CONFIRM(11);

        private final byte value;

        private RequestType(int value) {
            this.value = (byte)value;
        }

        public static RequestType of(int value) {
            return RequestType.values()[value];
        }

        public byte value() {
            return this.value;
        }
    }

    public static enum FieldName {
        EVENT_TYPE_TAG("eventType"),
        MESSAGE_TAG("message"),
        ID_TAG("0"),
        DEVICE_NAME_TAG("1"),
        REQ_TYPE_TAG("2"),
        OPTIONS_TAG("3"),
        CYCLE_NAME_TAG("4"),
        ACQ_STAMP_TAG("5"),
        CYCLE_STAMP_TAG("6"),
        UPDATE_TYPE_TAG("7"),
        SELECTOR_TAG("8"),
        CLIENT_INFO_TAG("9"),
        NOTIFICATION_ID_TAG("a"),
        SOURCE_ID_TAG("b"),
        FILTERS_TAG("c"),
        DATA_TAG("x"),
        SESSION_ID_TAG("d"),
        SESSION_BODY_TAG("e"),
        PROPERTY_NAME_TAG("f");

        private final String name;

        private FieldName(String name) {
            this.name = name;
        }

        public String value() {
            return this.name;
        }
    }

    public static enum FrameType {
        HEADER(0),
        BODY(1),
        BODY_DATA_CONTEXT(2),
        BODY_REQUEST_CONTEXT(3),
        BODY_EXCEPTION(4);

        private final byte value;

        private FrameType(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }
    }

    public static enum MessageType {
        SERVER_CONNECT_ACK(1),
        SERVER_REP(2),
        SERVER_HB(3),
        CLIENT_CONNECT(32),
        CLIENT_REQ(33),
        CLIENT_HB(34);

        private static final int CLIENT_API_RANGE = 4;
        private static final int SERVER_API_RANGE = 32;
        private final byte value;

        private MessageType(int value) {
            this.value = (byte)value;
        }

        public byte value() {
            return this.value;
        }

        public static MessageType of(int value) {
            if (value < 4) {
                return MessageType.values()[value - 1];
            }
            return MessageType.values()[value - 32 + CLIENT_CONNECT.ordinal()];
        }
    }
}

