/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client.cmwlight;

import io.opencmw.client.cmwlight.CmwLightProtocol;
import java.util.Map;
import java.util.Objects;
import org.zeromq.ZFrame;

public class CmwLightMessage {
    public CmwLightProtocol.MessageType messageType;
    public String version;
    public CmwLightProtocol.RequestType requestType;
    public long id;
    public String deviceName;
    public CmwLightProtocol.UpdateType updateType;
    public String sessionId;
    public String propertyName;
    public Map<String, Object> options;
    public Map<String, Object> data;
    public ZFrame bodyData;
    public ExceptionMessage exceptionMessage;
    public RequestContext requestContext;
    public DataContext dataContext;
    public long notificationId;
    public long sourceId;
    public Map<String, Object> sessionBody;
    public static final CmwLightMessage SERVER_HB = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_HB);
    public static final CmwLightMessage CLIENT_HB = new CmwLightMessage(CmwLightProtocol.MessageType.CLIENT_HB);

    public static CmwLightMessage connectAck(String version) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_CONNECT_ACK);
        msg.version = version;
        return msg;
    }

    public static CmwLightMessage connect(String version) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.CLIENT_CONNECT);
        msg.version = version;
        return msg;
    }

    public static CmwLightMessage subscribeRequest(String sessionId, long id, String device, String property, Map<String, Object> options, RequestContext requestContext, CmwLightProtocol.UpdateType updateType) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.CLIENT_REQ);
        msg.requestType = CmwLightProtocol.RequestType.SUBSCRIBE;
        msg.id = id;
        msg.options = options;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.requestContext = requestContext;
        msg.updateType = updateType;
        return msg;
    }

    public static CmwLightMessage subscribeReply(String sessionId, long id, String device, String property, Map<String, Object> options) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.SUBSCRIBE;
        msg.id = id;
        msg.options = options;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        return msg;
    }

    public static CmwLightMessage unsubscribeRequest(String sessionId, long id, String device, String property, Map<String, Object> options, CmwLightProtocol.UpdateType updateType) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.CLIENT_REQ);
        msg.requestType = CmwLightProtocol.RequestType.UNSUBSCRIBE;
        msg.id = id;
        msg.options = options;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = updateType;
        return msg;
    }

    public static CmwLightMessage getRequest(String sessionId, long id, String device, String property, RequestContext requestContext) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.CLIENT_REQ;
        msg.requestType = CmwLightProtocol.RequestType.GET;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.requestContext = requestContext;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        return msg;
    }

    public static CmwLightMessage setRequest(String sessionId, long id, String device, String property, ZFrame data, RequestContext requestContext) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.CLIENT_REQ;
        msg.requestType = CmwLightProtocol.RequestType.SET;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.requestContext = requestContext;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        msg.bodyData = data;
        return msg;
    }

    public static CmwLightMessage exceptionReply(String sessionId, long id, String device, String property, String message, long contextAcqStamp, long contextCycleStamp, byte type) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.EXCEPTION;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        msg.exceptionMessage = new ExceptionMessage(contextAcqStamp, contextCycleStamp, message, type);
        return msg;
    }

    public static CmwLightMessage subscribeExceptionReply(String sessionId, long id, String device, String property, String message, long contextAcqStamp, long contextCycleStamp, byte type) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.SUBSCRIBE_EXCEPTION;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        msg.exceptionMessage = new ExceptionMessage(contextAcqStamp, contextCycleStamp, message, type);
        return msg;
    }

    public static CmwLightMessage notificationExceptionReply(String sessionId, long id, String device, String property, String message, long contextAcqStamp, long contextCycleStamp, byte type) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.NOTIFICATION_EXC;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        msg.exceptionMessage = new ExceptionMessage(contextAcqStamp, contextCycleStamp, message, type);
        return msg;
    }

    public static CmwLightMessage notificationReply(String sessionId, long id, String device, String property, ZFrame data, long notificationId, DataContext requestContext, CmwLightProtocol.UpdateType updateType) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.NOTIFICATION_DATA;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.notificationId = notificationId;
        msg.options = Map.of(CmwLightProtocol.FieldName.NOTIFICATION_ID_TAG.value(), notificationId);
        msg.dataContext = requestContext;
        msg.updateType = updateType;
        msg.bodyData = data;
        return msg;
    }

    public static CmwLightMessage getReply(String sessionId, long id, String device, String property, ZFrame data, DataContext requestContext) {
        CmwLightMessage msg = new CmwLightMessage(CmwLightProtocol.MessageType.SERVER_REP);
        msg.requestType = CmwLightProtocol.RequestType.REPLY;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.dataContext = requestContext;
        msg.bodyData = data;
        return msg;
    }

    public static CmwLightMessage sessionConfirmReply(String sessionId, long id, String device, String property, Map<String, Object> options) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.SERVER_REP;
        msg.requestType = CmwLightProtocol.RequestType.SESSION_CONFIRM;
        msg.id = id;
        msg.options = options;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        return msg;
    }

    public static CmwLightMessage eventReply(String sessionId, long id, String device, String property) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.SERVER_REP;
        msg.requestType = CmwLightProtocol.RequestType.EVENT;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        return msg;
    }

    public static CmwLightMessage eventRequest(String sessionId, long id, String device, String property) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.CLIENT_REQ;
        msg.requestType = CmwLightProtocol.RequestType.EVENT;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        return msg;
    }

    public static CmwLightMessage connectRequest(String sessionId, long id, String device, String property) {
        CmwLightMessage msg = new CmwLightMessage();
        msg.messageType = CmwLightProtocol.MessageType.CLIENT_REQ;
        msg.requestType = CmwLightProtocol.RequestType.CONNECT;
        msg.id = id;
        msg.sessionId = sessionId;
        msg.deviceName = device;
        msg.propertyName = property;
        msg.updateType = CmwLightProtocol.UpdateType.NORMAL;
        return msg;
    }

    protected CmwLightMessage() {
    }

    protected CmwLightMessage(CmwLightProtocol.MessageType messageType) {
        this.messageType = messageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CmwLightMessage)) {
            return false;
        }
        CmwLightMessage that = (CmwLightMessage)o;
        return this.id == that.id && this.notificationId == that.notificationId && this.sourceId == that.sourceId && this.messageType == that.messageType && Objects.equals(this.version, that.version) && this.requestType == that.requestType && Objects.equals(this.deviceName, that.deviceName) && this.updateType == that.updateType && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.propertyName, that.propertyName) && Objects.equals(this.options, that.options) && Objects.equals(this.data, that.data) && Objects.equals(this.bodyData, that.bodyData) && Objects.equals(this.exceptionMessage, that.exceptionMessage) && Objects.equals(this.requestContext, that.requestContext) && Objects.equals(this.dataContext, that.dataContext) && Objects.equals(this.sessionBody, that.sessionBody);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.version, this.requestType, this.id, this.deviceName, this.updateType, this.sessionId, this.propertyName, this.options, this.data, this.bodyData, this.exceptionMessage, this.requestContext, this.dataContext, this.notificationId, this.sourceId, this.sessionBody});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CmwMessage: ");
        block0 : switch (this.messageType) {
            case CLIENT_CONNECT: {
                sb.append("Connection request, client version='").append(this.version).append('\'');
                break;
            }
            case SERVER_CONNECT_ACK: {
                sb.append("Connection ack, server version='").append(this.version).append('\'');
                break;
            }
            case CLIENT_HB: {
                sb.append("client heartbeat");
                break;
            }
            case SERVER_HB: {
                sb.append("server heartbeat");
                break;
            }
            case SERVER_REP: {
                sb.append("server reply: ").append(this.requestType.name());
            }
            case CLIENT_REQ: {
                if (this.messageType == CmwLightProtocol.MessageType.CLIENT_REQ) {
                    sb.append("client request: ").append(this.requestType.name());
                }
                sb.append(" id: ").append(this.id).append(" deviceName=").append(this.deviceName).append(", updateType=").append((Object)this.updateType).append(", sessionId='").append(this.sessionId).append("', propertyName='").append(this.propertyName).append("', options=").append(this.options).append(", data=").append(this.data).append(", sourceId=").append(this.sourceId);
                switch (this.requestType) {
                    case GET: 
                    case SET: 
                    case SUBSCRIBE: 
                    case UNSUBSCRIBE: {
                        sb.append("\n  requestContext=").append(this.requestContext);
                        break block0;
                    }
                    case REPLY: 
                    case NOTIFICATION_DATA: {
                        sb.append(", notificationId=").append(this.notificationId).append("\n  bodyData=").append(this.bodyData).append("\n  dataContext=").append(this.dataContext);
                        break block0;
                    }
                    case EXCEPTION: 
                    case NOTIFICATION_EXC: 
                    case SUBSCRIBE_EXCEPTION: {
                        sb.append("\n  exceptionMessage=").append(this.exceptionMessage);
                        break block0;
                    }
                    case SESSION_CONFIRM: {
                        sb.append(", sessionBody='").append(this.sessionBody).append('\'');
                        break block0;
                    }
                    case CONNECT: 
                    case EVENT: {
                        break block0;
                    }
                }
                throw new IllegalStateException("unknown client request message type: " + this.messageType);
            }
            default: {
                throw new IllegalStateException("unknown message type: " + this.messageType);
            }
        }
        return sb.toString();
    }

    public static class ExceptionMessage {
        public long contextAcqStamp;
        public long contextCycleStamp;
        public String message;
        public byte type;

        public ExceptionMessage(long contextAcqStamp, long contextCycleStamp, String message, byte type) {
            this.contextAcqStamp = contextAcqStamp;
            this.contextCycleStamp = contextCycleStamp;
            this.message = message;
            this.type = type;
        }

        protected ExceptionMessage() {
        }

        public String toString() {
            return "ExceptionMessage{contextAcqStamp=" + this.contextAcqStamp + ", contextCycleStamp=" + this.contextCycleStamp + ", message='" + this.message + "', type=" + this.type + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExceptionMessage)) {
                return false;
            }
            ExceptionMessage that = (ExceptionMessage)o;
            return this.contextAcqStamp == that.contextAcqStamp && this.contextCycleStamp == that.contextCycleStamp && this.type == that.type && this.message.equals(that.message);
        }

        public int hashCode() {
            return Objects.hash(this.contextAcqStamp, this.contextCycleStamp, this.message, this.type);
        }
    }

    public static class DataContext {
        public String cycleName;
        public long cycleStamp;
        public long acqStamp;
        public Map<String, Object> data;

        public DataContext(String cycleName, long cycleStamp, long acqStamp, Map<String, Object> data) {
            this.cycleName = cycleName;
            this.cycleStamp = cycleStamp;
            this.acqStamp = acqStamp;
            this.data = data;
        }

        protected DataContext() {
        }

        public String toString() {
            return "DataContext{cycleName='" + this.cycleName + "', cycleStamp=" + this.cycleStamp + ", acqStamp=" + this.acqStamp + ", data=" + this.data + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataContext)) {
                return false;
            }
            DataContext that = (DataContext)o;
            return this.cycleStamp == that.cycleStamp && this.acqStamp == that.acqStamp && this.cycleName.equals(that.cycleName) && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.cycleName, this.cycleStamp, this.acqStamp, this.data);
        }
    }

    public static class RequestContext {
        public String selector;
        public Map<String, Object> data;
        public Map<String, Object> filters;

        public RequestContext(String selector, Map<String, Object> filters, Map<String, Object> data) {
            this.selector = selector;
            this.filters = filters;
            this.data = data;
        }

        protected RequestContext() {
        }

        public String toString() {
            return "RequestContext{selector='" + this.selector + "', data=" + this.data + ", filters=" + this.filters + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestContext)) {
                return false;
            }
            RequestContext that = (RequestContext)o;
            return this.selector.equals(that.selector) && Objects.equals(this.data, that.data) && Objects.equals(this.filters, that.filters);
        }

        public int hashCode() {
            return Objects.hash(this.selector, this.data, this.filters);
        }
    }
}

