/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client;

import io.opencmw.client.DataSourcePublisher;
import io.opencmw.client.DnsResolver;
import io.opencmw.domain.BinaryData;
import io.opencmw.rbac.RbacProvider;
import io.opencmw.utils.SystemProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZContext;

public class OpenCmwDnsResolver
implements DnsResolver,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenCmwDnsResolver.class);
    private static final List<String> APPLICABLE_SCHEMES = Arrays.asList("mdp", "mds", "mdr", "http", "https");
    private static final Pattern DNS_PATTERN = Pattern.compile("\\[(.*?)]");
    private final ZContext context;
    private final boolean ownsCtx;
    private final URI dnsServer;
    private final Duration timeOut;
    private final DataSourcePublisher dataSource;

    public OpenCmwDnsResolver(@NotNull URI dnsServer) {
        this(null, dnsServer, Duration.ofSeconds(1L));
    }

    public OpenCmwDnsResolver(ZContext context, @NotNull URI dnsServer, @NotNull Duration timeOut) {
        this.dnsServer = Objects.requireNonNull(dnsServer, "dnsServer may not be null");
        this.ownsCtx = context == null;
        this.context = Objects.requireNonNullElse(context, new ZContext(1));
        this.timeOut = timeOut;
        this.dataSource = new DataSourcePublisher(context, null, null, null, OpenCmwDnsResolver.class.getName());
        this.dataSource.start();
        LockSupport.parkNanos(Duration.ofMillis(1000L).toNanos());
    }

    @Override
    public List<String> getApplicableSchemes() {
        return APPLICABLE_SCHEMES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<URI, List<URI>> resolveNames(List<URI> devicesToResolve) throws UnknownHostException {
        int liveness = SystemProperties.getValueIgnoreCase((String)"OpenCMW.heartBeatLiveness", (int)3);
        try (DataSourcePublisher.Client client = this.dataSource.getClient();){
            String query = devicesToResolve.stream().map(URI::toString).collect(Collectors.joining(","));
            URI queryURI = URI.create(this.dnsServer + "/mmi.dns?" + query);
            Future<BinaryData> reply4 = client.get(queryURI, null, BinaryData.class, new RbacProvider[0]);
            for (int attempt = 0; attempt < liveness; ++attempt) {
                try {
                    Map<URI, List<URI>> map = OpenCmwDnsResolver.parseDnsReply(Objects.requireNonNull(reply4.get((long)this.timeOut.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).data, "reply data is null"));
                    return map;
                }
                catch (InterruptedException | NullPointerException | ExecutionException | TimeoutException e) {
                    try {
                        String exception = e.getClass().getName() + ": " + e.getMessage();
                        LOGGER.atWarn().addArgument((Object)OpenCmwDnsResolver.class.getSimpleName()).addArgument((Object)attempt).addArgument((Object)this.dnsServer).addArgument(devicesToResolve).addArgument((Object)exception).log("{} - attempt {}: dns server {} could not resolve '{}'  error: {}");
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        throw new UnknownHostException("cannot resolve URI - dnsServer: " + this.dnsServer + " (timeout reached: " + this.timeOut.toMillis() * (long)liveness + " ms) - URI list: " + devicesToResolve);
                    }
                }
            }
        }
    }

    @Override
    public void close() {
        this.dataSource.close();
        if (this.ownsCtx) {
            this.context.close();
        }
    }

    public static Map<URI, List<URI>> parseDnsReply(byte[] dnsReply) {
        if (dnsReply == null || dnsReply.length == 0 || !OpenCmwDnsResolver.isUTF8(dnsReply)) {
            return Collections.emptyMap();
        }
        String reply = new String(dnsReply, StandardCharsets.UTF_8);
        if (reply.isBlank()) {
            return Collections.emptyMap();
        }
        Matcher matchPattern = DNS_PATTERN.matcher(reply);
        ConcurrentHashMap<URI, List<URI>> map = new ConcurrentHashMap<URI, List<URI>>();
        while (matchPattern.find()) {
            String device = matchPattern.group(1);
            String[] message = device.split("(: )", 2);
            assert (message.length == 2) : "could not split into 2 segments: " + device;
            try {
                List uriList = map.computeIfAbsent(new URI(message[0]), deviceName -> new ArrayList());
                Stream.of(StringUtils.split((String)message[1], (String)",")).filter(uriString -> !"null".equalsIgnoreCase((String)uriString)).forEach(uriString -> {
                    try {
                        uriList.add(new URI(StringUtils.strip((String)uriString)));
                    }
                    catch (URISyntaxException e) {
                        LOGGER.atError().setCause((Throwable)e).addArgument((Object)message[0]).addArgument(uriString).log("could not parse device '{}' uri: '{}}'");
                    }
                });
            }
            catch (URISyntaxException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)message[1]).log("could not parse device line '{}'");
            }
        }
        return map;
    }

    public static boolean isUTF8(byte[] array) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        ByteBuffer buf = ByteBuffer.wrap(array);
        try {
            decoder.decode(buf);
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }
}

