/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client;

import com.lmax.disruptor.EventHandler;
import io.opencmw.EventStore;
import io.opencmw.Filter;
import io.opencmw.MimeType;
import io.opencmw.OpenCmwConstants;
import io.opencmw.OpenCmwProtocol;
import io.opencmw.QueryParameterParser;
import io.opencmw.RingBufferEvent;
import io.opencmw.client.DataSource;
import io.opencmw.client.OpenCmwDataSource;
import io.opencmw.client.cmwlight.CmwLightDataSource;
import io.opencmw.client.rest.RestDataSource;
import io.opencmw.domain.BinaryData;
import io.opencmw.filter.EvtTypeFilter;
import io.opencmw.filter.FilterRegistry;
import io.opencmw.rbac.RbacProvider;
import io.opencmw.serialiser.IoBuffer;
import io.opencmw.serialiser.IoClassSerialiser;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.serialiser.spi.FastByteBuffer;
import io.opencmw.utils.CustomFuture;
import io.opencmw.utils.SharedPointer;
import io.opencmw.utils.SystemProperties;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class DataSourcePublisher
implements Runnable,
Closeable {
    public static final int MIN_FRAMES_INTERNAL_MSG = 3;
    protected static final ZFrame EMPTY_ZFRAME = new ZFrame(OpenCmwProtocol.EMPTY_FRAME);
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourcePublisher.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    protected final long heartbeatInterval = SystemProperties.getValueIgnoreCase((String)"OpenCMW.heartBeat", (long)1000L);
    protected final String inprocCtrl = "inproc://dsPublisher#" + INSTANCE_COUNT.incrementAndGet();
    protected final Map<String, ThePromisedFuture<?, ?>> requests = new ConcurrentHashMap();
    protected final Map<String, DataSource> clientMap = new ConcurrentHashMap<String, DataSource>();
    protected final AtomicInteger internalReqIdGenerator = new AtomicInteger(0);
    protected final ExecutorService executor;
    protected final ZContext context;
    protected final ZMQ.Poller poller;
    protected final ZMQ.Socket sourceSocket;
    protected final String clientId;
    private final IoBuffer byteBuffer = new FastByteBuffer(0, true, null);
    private final IoClassSerialiser ioClassSerialiser = new IoClassSerialiser(this.byteBuffer, new Class[0]);
    private final AtomicBoolean shallRun = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final EventStore rawDataEventStore;
    private final RbacProvider rbacProvider;
    private final EventStore publicationTarget;
    private final AtomicReference<Thread> threadReference = new AtomicReference();

    public DataSourcePublisher(RbacProvider rbacProvider, ExecutorService executorService, String ... clientId) {
        this(null, null, rbacProvider, executorService, clientId);
        this.start();
    }

    public DataSourcePublisher(ZContext ctx, EventStore publicationTarget, RbacProvider rbacProvider, ExecutorService executorService, String ... clientId) {
        this.context = Objects.requireNonNullElse(ctx, new ZContext(SystemProperties.getValueIgnoreCase((String)"OpenCMW.nIoThreads", (int)1)));
        this.executor = Objects.requireNonNullElse(executorService, Executors.newCachedThreadPool());
        this.poller = this.context.createPoller(1);
        this.sourceSocket = this.context.createSocket(SocketType.DEALER);
        OpenCmwConstants.setDefaultSocketParameters((ZMQ.Socket)this.sourceSocket);
        this.sourceSocket.bind(this.inprocCtrl);
        this.poller.register(this.sourceSocket, 1);
        this.rawDataEventStore = EventStore.getFactory().setSingleProducer(true).setFilterConfig(new Class[]{EvtTypeFilter.class}).build();
        this.rawDataEventStore.register(new EventHandler[]{this::internalEventHandler});
        this.clientId = clientId.length == 1 ? clientId[0] : DataSourcePublisher.class.getName();
        this.rbacProvider = rbacProvider;
        this.publicationTarget = publicationTarget;
    }

    public ZContext getContext() {
        return this.context;
    }

    public EventStore getRawDataEventStore() {
        return this.rawDataEventStore;
    }

    public Client getClient() {
        return new Client();
    }

    @Override
    public void close() {
        this.shallRun.set(false);
        Thread thread = this.threadReference.get();
        if (thread != null) {
            thread.interrupt();
            try {
                thread.join(this.heartbeatInterval);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(thread.getName() + " did not shut down in " + this.heartbeatInterval + " ms", e);
            }
        }
        thread = this.threadReference.get();
        if (this.running.get() && thread != null) {
            thread.interrupt();
        }
        this.poller.close();
        this.sourceSocket.close();
    }

    public void start() {
        Thread thread = this.threadReference.get();
        if (thread != null) {
            LOGGER.atWarn().addArgument((Object)thread.getName()).log("Thread '{}' already running");
            return;
        }
        String threadName = "DataSourceProducerThread-" + this.clientId;
        thread = new Thread(null, this, threadName, 0L);
        this.threadReference.set(thread);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.close();
    }

    @Override
    public void run() {
        if (this.shallRun.getAndSet(true)) {
            return;
        }
        this.running.set(true);
        this.rawDataEventStore.start();
        long nextHousekeeping = System.currentTimeMillis();
        long timeOut = 0L;
        while (!(Thread.interrupted() || !this.shallRun.get() || this.context.isClosed() || timeOut > 0L && -1 == this.poller.poll(timeOut) || this.context.isClosed())) {
            for (boolean dataAvailable = true; dataAvailable && System.currentTimeMillis() < nextHousekeeping && this.shallRun.get(); dataAvailable |= this.handleControlSocket()) {
                dataAvailable = this.handleDataSourceSockets();
            }
            nextHousekeeping = this.clientMap.values().stream().mapToLong(DataSource::housekeeping).min().orElse(System.currentTimeMillis() + this.heartbeatInterval);
            timeOut = nextHousekeeping - System.currentTimeMillis();
        }
        if (this.shallRun.get()) {
            LOGGER.atError().addArgument(this.clientMap.values()).log("poller returned negative value - abort run() - clients = {}");
        } else {
            LOGGER.atDebug().log("Shutting down DataSourcePublisher");
        }
        this.rawDataEventStore.stop();
        for (DataSource dataSource : this.clientMap.values()) {
            try {
                dataSource.close();
            }
            catch (Exception exception) {}
        }
        this.running.set(false);
        this.threadReference.set(null);
    }

    protected boolean handleControlSocket() {
        ZMsg controlMsg = ZMsg.recvMsg((ZMQ.Socket)this.sourceSocket, (boolean)false);
        if (controlMsg == null) {
            return false;
        }
        assert (controlMsg.size() >= 3) : "ignoring invalid message - message size: " + controlMsg.size();
        OpenCmwProtocol.Command msgType = OpenCmwProtocol.Command.getCommand((byte[])controlMsg.pollFirst().getData());
        String requestId = Objects.requireNonNull(controlMsg.pollFirst()).getString(StandardCharsets.UTF_8);
        URI endpoint = URI.create(Objects.requireNonNull(controlMsg.pollFirst()).getString(StandardCharsets.UTF_8));
        byte[] data = controlMsg.isEmpty() ? OpenCmwProtocol.EMPTY_FRAME : controlMsg.pollFirst().getData();
        byte[] rbacToken = controlMsg.isEmpty() ? OpenCmwProtocol.EMPTY_FRAME : controlMsg.pollFirst().getData();
        DataSource client = this.getClient(endpoint);
        switch (msgType) {
            case SUBSCRIBE: {
                client.subscribe(requestId, endpoint, rbacToken);
                return true;
            }
            case GET_REQUEST: {
                client.get(requestId, endpoint, data, rbacToken);
                return true;
            }
            case SET_REQUEST: {
                client.set(requestId, endpoint, data, rbacToken);
                return true;
            }
            case UNSUBSCRIBE: {
                client.unsubscribe(requestId);
                this.requests.remove(requestId);
                return true;
            }
        }
        throw new UnsupportedOperationException("Illegal operation type");
    }

    protected boolean handleDataSourceSockets() {
        boolean dataAvailable = false;
        for (DataSource entry : this.clientMap.values()) {
            ZMsg reply = entry.getMessage();
            if (reply == null || reply.isEmpty()) continue;
            dataAvailable = true;
            String reqId = Objects.requireNonNull(reply.pollFirst()).getString(StandardCharsets.UTF_8);
            ThePromisedFuture<?, ?> returnFuture = this.requests.get(reqId);
            assert (returnFuture != null) : "no future available for reqId:" + reqId;
            this.rawDataEventStore.getRingBuffer().publishEvent((event, sequence) -> {
                if (returnFuture.getReplyType() != OpenCmwProtocol.Command.SUBSCRIBE) {
                    assert (returnFuture.getInternalRequestID().equals(reqId)) : "requestID mismatch";
                    this.requests.remove(reqId);
                }
                String endpoint = Objects.requireNonNull(reply.pollFirst()).getString(StandardCharsets.UTF_8);
                InternalDomainObject internalData = new InternalDomainObject(reply, returnFuture);
                event.arrivalTimeStamp = System.currentTimeMillis();
                event.payload = Objects.requireNonNullElseGet(event.payload, SharedPointer::new);
                event.payload.set((Object)internalData);
                EvtTypeFilter evtTypeFilter = (EvtTypeFilter)event.getFilter(EvtTypeFilter.class);
                evtTypeFilter.updateType = returnFuture.requestType;
                evtTypeFilter.property = URI.create(endpoint);
            });
        }
        return dataAvailable;
    }

    protected <R> ThePromisedFuture<R, ?> newRequestFuture(URI endpoint, Class<R> requestedDomainObjType, OpenCmwProtocol.Command requestType, String requestId) {
        FilterRegistry.checkClassForNewFilters(requestedDomainObjType);
        ThePromisedFuture requestFuture = new ThePromisedFuture(endpoint, requestedDomainObjType, null, requestType, requestId, null);
        ThePromisedFuture oldEntry = this.requests.put(requestId, requestFuture);
        assert (oldEntry == null) : "requestID '" + requestId + "' already present in requestFutureMap";
        return requestFuture;
    }

    protected <R, C> ThePromisedFuture<R, C> newSubscriptionFuture(URI endpoint, Class<R> requestedDomainObjType, Class<C> contextType, String requestId, NotificationListener<R, C> listener) {
        FilterRegistry.checkClassForNewFilters(requestedDomainObjType);
        ThePromisedFuture<R, C> requestFuture = new ThePromisedFuture<R, C>(endpoint, requestedDomainObjType, contextType, OpenCmwProtocol.Command.SUBSCRIBE, requestId, listener);
        ThePromisedFuture<R, C> oldEntry = this.requests.put(requestId, requestFuture);
        assert (oldEntry == null) : "requestID '" + requestId + "' already present in requestFutureMap";
        return requestFuture;
    }

    protected void internalEventHandler(RingBufferEvent event, long sequence, boolean endOfBatch) {
        Object replyDomainObject;
        String exceptionMsg;
        block17: {
            boolean notifyFuture;
            EvtTypeFilter evtTypeFilter = (EvtTypeFilter)event.getFilter(EvtTypeFilter.class);
            switch (evtTypeFilter.updateType) {
                case GET_REQUEST: 
                case SET_REQUEST: {
                    notifyFuture = true;
                    break;
                }
                case SUBSCRIBE: {
                    notifyFuture = false;
                    break;
                }
                default: {
                    return;
                }
            }
            URI endpointURI = evtTypeFilter.property;
            InternalDomainObject domainObject = Objects.requireNonNull((InternalDomainObject)event.payload.get(InternalDomainObject.class), "empty payload");
            byte[] body = Objects.requireNonNull(domainObject.data.poll(), "null body data").getData();
            exceptionMsg = Objects.requireNonNull(domainObject.data.poll(), "null exception message").getString(StandardCharsets.UTF_8);
            replyDomainObject = null;
            if (exceptionMsg.isBlank()) {
                try {
                    Class<BinaryData> reqClassType = domainObject.future.getRequestedDomainObjType();
                    if (reqClassType.isAssignableFrom(BinaryData.class)) {
                        replyDomainObject = new BinaryData(domainObject.future.getInternalRequestID(), MimeType.BINARY, body);
                    } else if (body.length != 0) {
                        this.ioClassSerialiser.setDataBuffer((IoBuffer)FastByteBuffer.wrap((byte[])body));
                        replyDomainObject = this.ioClassSerialiser.deserialiseObject(reqClassType);
                        this.ioClassSerialiser.setDataBuffer(this.byteBuffer);
                    }
                    if (notifyFuture) {
                        domainObject.future.castAndSetReply(replyDomainObject);
                    }
                    if (domainObject.future.listener != null) {
                        BinaryData finalDomainObj = replyDomainObject;
                        Object contextObject = domainObject.future.contextType == null ? QueryParameterParser.getMap((String)endpointURI.getQuery()) : QueryParameterParser.parseQueryParameter(domainObject.future.contextType, (String)endpointURI.getQuery());
                        this.executor.submit(() -> domainObject.future.notifyListener(finalDomainObj, contextObject));
                    }
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    ProtocolException protocolException = new ProtocolException("\u001b[31merror deserialising object:\n" + sw.toString() + "\u001b[0m");
                    if (notifyFuture) {
                        domainObject.future.setException(protocolException);
                        break block17;
                    }
                    this.executor.submit(() -> domainObject.future.listener.updateException(protocolException));
                }
            } else if (notifyFuture) {
                domainObject.future.setException(new ProtocolException(exceptionMsg));
            } else {
                this.executor.submit(() -> domainObject.future.listener.updateException(new ProtocolException(exceptionMsg)));
            }
        }
        if (this.publicationTarget != null) {
            this.publicationTarget.getRingBuffer().publishEvent(this::publishToExternalStore, (Object)event, replyDomainObject, (Object)exceptionMsg);
        }
    }

    protected void publishToExternalStore(RingBufferEvent publishEvent, long seq, RingBufferEvent sourceEvent, Object replyDomainObject, String exception) {
        sourceEvent.copyTo(publishEvent);
        publishEvent.payload = new SharedPointer();
        if (replyDomainObject != null) {
            publishEvent.payload.set(replyDomainObject);
        }
        if (exception != null && !exception.isBlank()) {
            publishEvent.throwables.add(new Exception(exception));
        }
        EvtTypeFilter evtTypeFilter = (EvtTypeFilter)publishEvent.getFilter(EvtTypeFilter.class);
        for (Filter filter : publishEvent.filters) {
            if (filter instanceof EvtTypeFilter) continue;
            try {
                Filter filterFromQuery = (Filter)QueryParameterParser.parseQueryParameter(filter.getClass(), (String)evtTypeFilter.property.getQuery());
                filterFromQuery.copyTo(filter);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.atWarn().addArgument((Object)evtTypeFilter.property).setCause((Throwable)e).log("Error while parsing filters from endpoint: {}");
            }
        }
    }

    protected DataSource getClient(URI endpoint) {
        return this.clientMap.computeIfAbsent(endpoint.getScheme() + ":/" + OpenCmwConstants.getDeviceName((URI)endpoint), requestedEndPoint -> {
            DataSource dataSource = DataSource.getFactory(URI.create(requestedEndPoint)).newInstance(this.context, endpoint, Duration.ofMillis(100L), this.executor, Long.toString(this.internalReqIdGenerator.incrementAndGet()));
            this.poller.register(dataSource.getSocket(), 1);
            return dataSource;
        });
    }

    static {
        DataSource.register(CmwLightDataSource.FACTORY);
        DataSource.register(RestDataSource.FACTORY);
        DataSource.register(OpenCmwDataSource.FACTORY);
    }

    protected static class InternalDomainObject {
        public final ZMsg data;
        public final ThePromisedFuture<?, ?> future;

        protected InternalDomainObject(ZMsg data, ThePromisedFuture<?, ?> future) {
            this.data = Objects.requireNonNull(data, "null data");
            this.future = Objects.requireNonNull(future, "null future");
        }

        public String toString() {
            return "InternalDomainObject{data=" + this.data + ", future=" + this.future + "}";
        }
    }

    protected static class ThePromisedFuture<R, C>
    extends CustomFuture<R> {
        private final URI endpoint;
        private final Class<R> requestedDomainObjType;
        private final Class<C> contextType;
        private final OpenCmwProtocol.Command requestType;
        private final String internalRequestID;
        private final NotificationListener<R, C> listener;

        public ThePromisedFuture(URI endpoint, Class<R> requestedDomainObjType, Class<C> contextType, OpenCmwProtocol.Command requestType, String internalRequestID, NotificationListener<R, C> listener) {
            this.endpoint = endpoint;
            this.requestedDomainObjType = requestedDomainObjType;
            this.contextType = contextType;
            this.requestType = requestType;
            this.internalRequestID = internalRequestID;
            this.listener = listener;
        }

        public URI getEndpoint() {
            return this.endpoint;
        }

        public OpenCmwProtocol.Command getReplyType() {
            return this.requestType;
        }

        public Class<R> getRequestedDomainObjType() {
            return this.requestedDomainObjType;
        }

        public String getInternalRequestID() {
            return this.internalRequestID;
        }

        public void notifyListener(Object obj, Object contextObject) {
            if (obj == null || !this.requestedDomainObjType.isAssignableFrom(obj.getClass()) || !this.contextType.isAssignableFrom(contextObject.getClass())) {
                LOGGER.atError().addArgument((Object)this.requestedDomainObjType.getName()).addArgument((Object)(obj == null ? "null" : obj.getClass().getName())).log("Got wrong type for notification, got {} expected {}");
            } else {
                this.listener.dataUpdate(obj, contextObject);
            }
        }

        protected void castAndSetReply(Object newValue) {
            this.setReply(newValue);
        }
    }

    public class Client
    implements Closeable {
        private final ZMQ.Socket clientSocket;
        private IoBuffer byteBuffer;
        private IoClassSerialiser ioClassSerialiser;

        private Client() {
            this.clientSocket = DataSourcePublisher.this.context.createSocket(SocketType.DEALER);
            this.clientSocket.connect(DataSourcePublisher.this.inprocCtrl);
        }

        public <R, C> Future<R> get(URI endpoint, C requestContext, Class<R> requestedDomainObjType, RbacProvider ... rbacProvider) {
            String requestId = DataSourcePublisher.this.clientId + DataSourcePublisher.this.internalReqIdGenerator.incrementAndGet();
            URI endpointQuery = this.getEndpointQuery(endpoint, requestContext);
            ThePromisedFuture<R, ?> rThePromisedFuture = DataSourcePublisher.this.newRequestFuture(endpointQuery, requestedDomainObjType, OpenCmwProtocol.Command.GET_REQUEST, requestId);
            this.request(requestId, OpenCmwProtocol.Command.GET_REQUEST, endpointQuery, null, requestContext, rbacProvider);
            return rThePromisedFuture;
        }

        public <R, C> Future<R> set(URI endpoint, R requestBody, C requestContext, Class<R> requestedDomainObjType, RbacProvider ... rbacProvider) {
            String requestId = DataSourcePublisher.this.clientId + DataSourcePublisher.this.internalReqIdGenerator.incrementAndGet();
            URI endpointQuery = this.getEndpointQuery(endpoint, requestContext);
            ThePromisedFuture<R, ?> rThePromisedFuture = DataSourcePublisher.this.newRequestFuture(endpointQuery, requestedDomainObjType, OpenCmwProtocol.Command.SET_REQUEST, requestId);
            this.request(requestId, OpenCmwProtocol.Command.SET_REQUEST, endpointQuery, requestBody, requestContext, rbacProvider);
            return rThePromisedFuture;
        }

        public <T> String subscribe(URI endpoint, Class<T> requestedDomainObjType, RbacProvider ... rbacProvider) {
            return this.subscribe(endpoint, requestedDomainObjType, (Object)null, null, null, rbacProvider);
        }

        public <T, C> String subscribe(URI endpoint, Class<T> requestedDomainObjType, C context, Class<C> contextType, NotificationListener<T, C> listener, RbacProvider ... rbacProvider) {
            String requestId = DataSourcePublisher.this.clientId + DataSourcePublisher.this.internalReqIdGenerator.incrementAndGet();
            URI endpointQuery = this.getEndpointQuery(endpoint, context);
            String reqId = DataSourcePublisher.this.newSubscriptionFuture((URI)endpointQuery, requestedDomainObjType, contextType, (String)requestId, listener).internalRequestID;
            this.request(requestId, OpenCmwProtocol.Command.SUBSCRIBE, endpointQuery, null, context, rbacProvider);
            return reqId;
        }

        public void unsubscribe(String requestId) {
            ZMsg msg = new ZMsg();
            msg.add(OpenCmwProtocol.Command.UNSUBSCRIBE.getData());
            msg.add(requestId);
            msg.add(DataSourcePublisher.this.requests.get((Object)requestId).endpoint.toString());
            msg.send(this.clientSocket);
        }

        @Override
        public void close() {
            this.clientSocket.close();
        }

        private IoClassSerialiser getSerialiser() {
            if (this.ioClassSerialiser == null) {
                this.byteBuffer = new FastByteBuffer(1024, true, null);
                this.ioClassSerialiser = new IoClassSerialiser(this.byteBuffer, new Class[0]);
            }
            this.byteBuffer.reset();
            return this.ioClassSerialiser;
        }

        private <C> URI getEndpointQuery(URI endpoint, C requestContext) {
            URI endpointQuery = endpoint;
            if (requestContext != null) {
                try {
                    endpointQuery = QueryParameterParser.appendQueryParameter((URI)endpoint, (String)QueryParameterParser.generateQueryParameter(requestContext));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid URL syntax for endpoint", e);
                }
            }
            return endpointQuery;
        }

        private <R, C> void request(String requestId, OpenCmwProtocol.Command requestType, URI endpoint, R requestBody, C requestContext, RbacProvider ... rbacProvider) {
            FilterRegistry.checkClassForNewFilters(requestContext);
            ZMsg msg = new ZMsg();
            msg.add(requestType.getData());
            msg.add(requestId);
            msg.add(endpoint.toString());
            if (requestBody == null) {
                msg.add(EMPTY_ZFRAME);
            } else {
                Class<? extends IoSerialiser> matchingSerialiser = DataSource.getFactory(endpoint).getMatchingSerialiserType(endpoint);
                IoClassSerialiser serialiser = this.getSerialiser();
                serialiser.setMatchedIoSerialiser(matchingSerialiser);
                serialiser.serialiseObject(requestBody);
                msg.add(Arrays.copyOfRange(this.byteBuffer.elements(), 0, this.byteBuffer.position()));
            }
            if (rbacProvider.length > 0 || DataSourcePublisher.this.rbacProvider != null) {
                LOGGER.atWarn().log("RbacProvider not yet implemented");
            } else {
                msg.add(EMPTY_ZFRAME);
            }
            if (!msg.send(this.clientSocket)) {
                LOGGER.atWarn().addArgument((Object)requestType).addArgument((Object)msg).log("could not send {} from client to source - message: {}");
            }
        }
    }

    public static interface NotificationListener<R, C> {
        public void dataUpdate(R var1, C var2);

        public void updateException(Throwable var1);
    }
}

