/*
 * Decompiled with CFR 0.152.
 */
package io.opencmw.client;

import io.opencmw.client.DnsResolver;
import io.opencmw.serialiser.IoSerialiser;
import io.opencmw.utils.NoDuplicatesList;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public abstract class DataSource
implements AutoCloseable {
    private static final List<Factory> IMPLEMENTATIONS = Collections.synchronizedList(new NoDuplicatesList());

    private DataSource() {
    }

    protected DataSource(@NotNull URI endpoint) {
        if (!this.getFactory().matches(endpoint)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " DataSource Implementation does not support endpoint: " + endpoint);
        }
    }

    public abstract void get(String var1, URI var2, byte[] var3, byte[] var4);

    public abstract ZMsg getMessage();

    public abstract ZMQ.Socket getSocket();

    public abstract long housekeeping();

    public abstract void set(String var1, URI var2, byte[] var3, byte[] var4);

    public abstract void subscribe(String var1, URI var2, byte[] var3);

    public abstract void unsubscribe(String var1);

    public static Factory getFactory(@NotNull URI endpoint) {
        for (Factory factory : IMPLEMENTATIONS) {
            if (!factory.matches(endpoint)) continue;
            return factory;
        }
        throw new UnsupportedOperationException("No DataSource implementation available for endpoint: " + endpoint);
    }

    public static void register(Factory factory) {
        IMPLEMENTATIONS.add(0, factory);
    }

    protected abstract Factory getFactory();

    public static interface Factory {
        public List<String> getApplicableSchemes();

        public Class<? extends IoSerialiser> getMatchingSerialiserType(@NotNull URI var1);

        public List<DnsResolver> getRegisteredDnsResolver();

        default public boolean matches(@NotNull URI endpoint) {
            String scheme = Objects.requireNonNull(endpoint.getScheme(), "required URI has no scheme defined: " + endpoint);
            return this.getApplicableSchemes().stream().anyMatch(s -> s.equalsIgnoreCase(scheme));
        }

        public DataSource newInstance(ZContext var1, @NotNull URI var2, @NotNull Duration var3, @NotNull ExecutorService var4, @NotNull String var5);

        default public void registerDnsResolver(@NotNull DnsResolver resolver) {
            ArrayList<String> list = new ArrayList<String>(this.getApplicableSchemes());
            list.retainAll(resolver.getApplicableSchemes());
            if (list.isEmpty()) {
                throw new IllegalArgumentException("resolver schemes not compatible with this DataSource: " + resolver);
            }
            this.getRegisteredDnsResolver().add(resolver);
        }
    }
}

