/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import io.openapitools.swagger.ClassUtils;
import io.openapitools.swagger.JaxRSScanner;
import io.openapitools.swagger.OutputFormat;
import io.openapitools.swagger.config.SwaggerConfig;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(name="skip", property="openapi.generation.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter
    private SwaggerConfig swaggerConfig;
    @Parameter
    private Set<String> resourcePackages;
    @Parameter(required=false, defaultValue="false")
    private Boolean useResourcePackagesChildren;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private String outputFilename = "swagger";
    @Parameter
    private Set<OutputFormat> outputFormats = Collections.singleton(OutputFormat.JSON);
    @Parameter(defaultValue="false")
    private boolean attachSwaggerArtifact;
    @Parameter(name="applicationClass", defaultValue="")
    private String applicationClass;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean prettyPrint;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip != null && this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"OpenApi generation is skipped.");
            return;
        }
        Thread.currentThread().setContextClassLoader(this.createClassLoader());
        Reader reader = new Reader(this.swaggerConfig == null ? new OpenAPI() : this.swaggerConfig.createSwaggerModel());
        JaxRSScanner reflectiveScanner = new JaxRSScanner(this.getLog(), this.resourcePackages, this.useResourcePackagesChildren);
        Application application = this.resolveApplication(reflectiveScanner);
        reader.setApplication(application);
        OpenAPI swagger = reader.read(reflectiveScanner.classes());
        if (this.outputDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("Created output directory " + this.outputDirectory));
        }
        this.outputFormats.forEach(format -> {
            try {
                File outputFile = new File(this.outputDirectory, this.outputFilename + "." + format.name().toLowerCase());
                format.write(swagger, outputFile, this.prettyPrint);
                if (this.attachSwaggerArtifact) {
                    this.projectHelper.attachArtifact(this.project, format.name().toLowerCase(), this.outputFilename, outputFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable write " + this.outputFilename + " document", e);
            }
        });
    }

    private Application resolveApplication(JaxRSScanner reflectiveScanner) {
        if (this.applicationClass == null || this.applicationClass.isEmpty()) {
            return reflectiveScanner.applicationInstance();
        }
        Class<?> clazz = ClassUtils.loadClass(this.applicationClass, Thread.currentThread().getContextClassLoader());
        if (clazz == null || !Application.class.isAssignableFrom(clazz)) {
            this.getLog().warn((CharSequence)"Provided application class does not implement javax.ws.rs.core.Application, skipping");
            return null;
        }
        Class<?> appClazz = clazz;
        return (Application)ClassUtils.createInstance(appClazz);
    }

    private URLClassLoader createClassLoader() {
        try {
            Collection<String> dependencies = this.getDependentClasspathElements();
            URL[] urls = new URL[dependencies.size()];
            int index = 0;
            for (String dependency : dependencies) {
                urls[index++] = Paths.get(dependency, new String[0]).toUri().toURL();
            }
            return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create class loader with compiled classes", e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException("Dependency resolution (runtime + compile) is required");
        }
    }

    private Collection<String> getDependentClasspathElements() throws DependencyResolutionRequiredException {
        List runtimeClasspathElements;
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        dependencies.add(this.project.getBuild().getOutputDirectory());
        List compileClasspathElements = this.project.getCompileClasspathElements();
        if (compileClasspathElements != null) {
            dependencies.addAll(compileClasspathElements);
        }
        if ((runtimeClasspathElements = this.project.getRuntimeClasspathElements()) != null) {
            dependencies.addAll(runtimeClasspathElements);
        }
        return dependencies;
    }
}

