/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import io.openapitools.swagger.ClassUtils;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.maven.plugin.logging.Log;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

class JaxRSScanner {
    private final Log log;
    private final Set<String> resourcePackages;
    private final boolean useResourcePackagesChildren;

    public JaxRSScanner(Log log, Set<String> resourcePackages, Boolean useResourcePackagesChildren) {
        this.log = log;
        this.resourcePackages = resourcePackages == null ? Collections.emptySet() : new HashSet<String>(resourcePackages);
        this.useResourcePackagesChildren = useResourcePackagesChildren != null && useResourcePackagesChildren != false;
    }

    Application applicationInstance() {
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[]{this.resourcePackages}).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set applicationClasses = reflections.getSubTypesOf(Application.class).stream().filter(this::filterClassByResourcePackages).collect(Collectors.toSet());
        if (applicationClasses.isEmpty()) {
            return null;
        }
        if (applicationClasses.size() > 1) {
            this.log.warn((CharSequence)"More than one javax.ws.rs.core.Application classes found on the classpath, skipping");
            return null;
        }
        return (Application)ClassUtils.createInstance((Class)applicationClasses.iterator().next());
    }

    Set<Class<?>> classes() {
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[]{this.resourcePackages}).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Stream<Class> apiClasses = reflections.getTypesAnnotatedWith(Path.class).stream().filter(this::filterClassByResourcePackages);
        Stream<Class> defClasses = reflections.getTypesAnnotatedWith(OpenAPIDefinition.class).stream().filter(this::filterClassByResourcePackages);
        return Stream.concat(apiClasses, defClasses).collect(Collectors.toSet());
    }

    private boolean filterClassByResourcePackages(Class<?> cls) {
        return this.resourcePackages.isEmpty() || this.resourcePackages.contains(cls.getPackage().getName()) || this.useResourcePackagesChildren && this.resourcePackages.stream().anyMatch(p -> cls.getPackage().getName().startsWith((String)p));
    }
}

