/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Path;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

class JaxRSScanner {
    private Set<String> resourcePackages = Collections.emptySet();
    private boolean useResourcePackagesChildren;

    public JaxRSScanner(Boolean useResourcePackagesChildren) {
        this.useResourcePackagesChildren = useResourcePackagesChildren != null && useResourcePackagesChildren != false;
    }

    Set<Class<?>> classes() {
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[]{this.resourcePackages}).setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Stream<Class> apiClasses = reflections.getTypesAnnotatedWith(Path.class).stream().filter(this::filterClassByResourcePackages);
        Stream<Class> defClasses = reflections.getTypesAnnotatedWith(OpenAPIDefinition.class).stream().filter(this::filterClassByResourcePackages);
        return Stream.concat(apiClasses, defClasses).collect(Collectors.toSet());
    }

    private boolean filterClassByResourcePackages(Class<?> cls) {
        return this.resourcePackages.isEmpty() || this.resourcePackages.contains(cls.getPackage().getName()) || this.useResourcePackagesChildren && this.resourcePackages.stream().anyMatch(p -> cls.getPackage().getName().startsWith((String)p));
    }

    void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages = new HashSet<String>(resourcePackages);
    }
}

