/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.swagger;

import io.openapitools.swagger.JaxRSScanner;
import io.openapitools.swagger.OutputFormat;
import io.openapitools.swagger.config.SwaggerConfig;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(name="skip", property="openapi.generation.skip", required=false, defaultValue="false")
    private Boolean skip;
    @Parameter
    private SwaggerConfig swaggerConfig;
    @Parameter
    private Set<String> resourcePackages;
    @Parameter(required=false, defaultValue="false")
    private Boolean useResourcePackagesChildren;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private String outputFilename = "swagger";
    @Parameter
    private Set<OutputFormat> outputFormats = Collections.singleton(OutputFormat.JSON);
    @Parameter(defaultValue="false")
    private boolean attachSwaggerArtifact;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean prettyPrint;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip != null && this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"OpenApi generation is skipped.");
            return;
        }
        Thread.currentThread().setContextClassLoader(this.createClassLoader());
        Reader reader = new Reader(this.swaggerConfig == null ? new OpenAPI() : this.swaggerConfig.createSwaggerModel());
        JaxRSScanner reflectiveScanner = new JaxRSScanner(this.useResourcePackagesChildren);
        if (this.resourcePackages != null && !this.resourcePackages.isEmpty()) {
            reflectiveScanner.setResourcePackages(this.resourcePackages);
        }
        OpenAPI swagger = reader.read(reflectiveScanner.classes());
        if (this.outputDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("Created output directory " + this.outputDirectory));
        }
        this.outputFormats.forEach(format -> {
            try {
                File outputFile = new File(this.outputDirectory, this.outputFilename + "." + format.name().toLowerCase());
                format.write(swagger, outputFile, this.prettyPrint);
                if (this.attachSwaggerArtifact) {
                    this.projectHelper.attachArtifact(this.project, format.name().toLowerCase(), "swagger", outputFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable write " + this.outputFilename + " document", e);
            }
        });
    }

    private URLClassLoader createClassLoader() {
        try {
            File compiled = new File(this.project.getBuild().getOutputDirectory());
            return new URLClassLoader(new URL[]{compiled.toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create class loader with compiled classes", e);
        }
    }
}

