/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import io.openapitools.jackson.dataformat.hal.HALLink;
import io.openapitools.jackson.dataformat.hal.annotation.Curie;
import io.openapitools.jackson.dataformat.hal.annotation.Curies;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HALBeanSerializer
extends BeanSerializerBase {
    private static final Logger LOG = LoggerFactory.getLogger(HALBeanSerializer.class);
    private final BeanDescription beanDescription;

    public HALBeanSerializer(BeanSerializerBase src, BeanDescription beanDescription) {
        super(src);
        this.beanDescription = beanDescription;
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this;
    }

    public BeanSerializerBase withFilterId(Object o) {
        return this;
    }

    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return this;
    }

    protected BeanSerializerBase asArraySerializer() {
        return this;
    }

    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return this;
    }

    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        FilteredProperties filtered = new FilteredProperties(bean, provider, this.beanDescription);
        jgen.writeStartObject();
        filtered.serialize(bean, jgen, provider);
        jgen.writeEndObject();
    }

    public void serializeWithType(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        FilteredProperties filtered = new FilteredProperties(bean, provider, this.beanDescription);
        WritableTypeId typeIdDef = this._typeIdDef(typeSer, bean, JsonToken.START_OBJECT);
        typeSer.writeTypePrefix(jgen, typeIdDef);
        filtered.serialize(bean, jgen, provider);
        typeSer.writeTypeSuffix(jgen, typeIdDef);
    }

    private class FilteredProperties {
        private List<BeanPropertyWriter> state = new ArrayList<BeanPropertyWriter>();
        private Map<String, LinkProperty> links = new TreeMap<String, LinkProperty>();
        private Map<String, BeanPropertyWriter> embedded = new TreeMap<String, BeanPropertyWriter>();
        private Map<String, String> curieMap = new TreeMap<String, String>();
        private Set<String> curiesInUse = new TreeSet<String>();

        public FilteredProperties(Object bean, SerializerProvider provider, BeanDescription beanDescription) throws IOException {
            this.populateCurieMap(beanDescription);
            BeanPropertyWriter[] props = HALBeanSerializer.this._filteredProps != null && provider.getActiveView() != null ? (BeanPropertyWriter[])Arrays.stream(HALBeanSerializer.this._filteredProps).filter(bpw -> {
                if (bpw == null || bpw.getViews() == null || bpw.getViews().length == 0) {
                    return provider.getConfig().isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
                }
                return Arrays.stream(bpw.getViews()).anyMatch(clazz -> clazz.isAssignableFrom(provider.getActiveView()));
            }).toArray(BeanPropertyWriter[]::new) : HALBeanSerializer.this._props;
            for (BeanPropertyWriter prop : props) {
                try {
                    if (prop.getAnnotation(EmbeddedResource.class) != null) {
                        Object object = prop.get(bean);
                        if (object == null) continue;
                        EmbeddedResource er = (EmbeddedResource)prop.getAnnotation(EmbeddedResource.class);
                        String val = "".equals(er.value()) ? prop.getName() : er.value();
                        this.addEmbeddedProperty(val, prop);
                        continue;
                    }
                    if (prop.getAnnotation(Link.class) != null) {
                        Object value;
                        String curie;
                        Link l = (Link)prop.getAnnotation(Link.class);
                        String relation = "".equals(l.value()) ? prop.getName() : l.value();
                        String string = curie = "".equals(l.curie()) ? null : l.curie();
                        if (!"".equals(l.curie())) {
                            this.curiesInUse.add(l.curie());
                        }
                        if ((value = prop.get(bean)) instanceof Collection) {
                            this.addLinks(relation, (Collection)prop.get(bean), curie);
                            continue;
                        }
                        if (!(value instanceof HALLink)) continue;
                        this.addLink(relation, (HALLink)prop.get(bean), curie);
                        continue;
                    }
                    this.state.add(prop);
                }
                catch (Exception e) {
                    HALBeanSerializer.this.wrapAndThrow(provider, e, bean, prop.getName());
                }
            }
            if (!this.curiesInUse.isEmpty()) {
                this.addCurieLinks();
            }
        }

        private void addCurieLinks() {
            ArrayList<HALLink> curieLinks = new ArrayList<HALLink>();
            for (String curie : this.curiesInUse) {
                if (this.curieMap.containsKey(curie)) {
                    curieLinks.add(new HALLink.Builder(this.curieMap.get(curie)).name(curie).build());
                    continue;
                }
                LOG.warn("No Curie/Curies annotation provided for [{}]", (Object)curie);
            }
            this.addLinks("curies", curieLinks, null);
        }

        private void populateCurieMap(BeanDescription beanDescription) {
            ArrayList<Curie> curieAnnotations = new ArrayList<Curie>();
            if (null != beanDescription.getClassAnnotations().get(Curie.class)) {
                curieAnnotations.add((Curie)beanDescription.getClassAnnotations().get(Curie.class));
            }
            if (null != beanDescription.getClassAnnotations().get(Curies.class)) {
                curieAnnotations.addAll(Arrays.asList(((Curies)beanDescription.getClassAnnotations().get(Curies.class)).value()));
            }
            for (Curie curie : curieAnnotations) {
                if (this.curieMap.containsKey(curie.prefix())) {
                    LOG.warn("Curie annotation already exists [{}]", (Object)curie.prefix());
                }
                this.curieMap.put(curie.prefix(), curie.href());
            }
        }

        public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (!this.links.isEmpty()) {
                jgen.writeFieldName("_links");
                jgen.writeStartObject();
                for (String rel : this.links.keySet()) {
                    jgen.writeFieldName(rel);
                    this.links.get(rel).serialize(jgen);
                }
                jgen.writeEndObject();
            }
            if (!this.embedded.isEmpty()) {
                jgen.writeFieldName("_embedded");
                jgen.writeStartObject();
                for (String rel : this.embedded.keySet()) {
                    try {
                        BeanPropertyWriter prop = this.renameBeanProperty(this.embedded.get(rel), rel);
                        prop.serializeAsField(bean, jgen, provider);
                    }
                    catch (Exception e) {
                        HALBeanSerializer.this.wrapAndThrow(provider, e, bean, rel);
                    }
                }
                jgen.writeEndObject();
            }
            for (BeanPropertyWriter prop : this.state) {
                try {
                    prop.serializeAsField(bean, jgen, provider);
                }
                catch (Exception e) {
                    HALBeanSerializer.this.wrapAndThrow(provider, e, bean, prop.getName());
                }
            }
        }

        private void addEmbeddedProperty(String rel, BeanPropertyWriter property) {
            if (this.embedded.put(rel, property) != null) {
                LOG.warn("Embedded resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }

        private void addLink(String rel, HALLink link, String curie) {
            if (this.links.put(this.applyCurieToRel(rel, curie), new LinkProperty(link)) != null) {
                LOG.warn("Link resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }

        private void addLinks(String rel, Collection<HALLink> links, String curie) {
            if (this.links.put(this.applyCurieToRel(rel, curie), new LinkProperty(links)) != null) {
                LOG.warn("Link resource already existed with rel [{}] in class [{}]", (Object)rel, (Object)HALBeanSerializer.this._handledType);
            }
        }

        private String applyCurieToRel(String rel, String curie) {
            return null == curie ? rel : curie + ":" + rel;
        }

        private BeanPropertyWriter renameBeanProperty(BeanPropertyWriter prop, final String newName) {
            return prop.rename(new NameTransformer(){

                public String transform(String name) {
                    return newName;
                }

                public String reverse(String transformed) {
                    return null;
                }
            });
        }
    }

    private static class LinkProperty {
        private HALLink link;
        private Collection<HALLink> links;

        public LinkProperty(HALLink link) {
            this.link = link;
        }

        public LinkProperty(Collection<HALLink> links) {
            this.links = links == null ? new HashSet() : links;
        }

        public void serialize(JsonGenerator jgen) throws IOException {
            if (this.link != null) {
                this.writeLinkObject(jgen, this.link);
            } else if (this.links != null) {
                jgen.writeStartArray();
                for (HALLink curLink : this.links) {
                    this.writeLinkObject(jgen, curLink);
                }
                jgen.writeEndArray();
            }
        }

        private void writeLinkObject(JsonGenerator jgen, HALLink link) throws IOException {
            jgen.writeObject((Object)link);
        }
    }
}

