/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import io.openapitools.jackson.dataformat.hal.annotation.Curie;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class CurieMap {
    private final ConcurrentHashMap<String, String> mappings = new ConcurrentHashMap();

    public CurieMap(Mapping ... mappings) {
        Objects.requireNonNull(mappings, "Non-null array must be provided");
        Arrays.stream(mappings).forEach(m -> this.mappings.put(((Mapping)m).prefix, ((Mapping)m).template));
    }

    public Optional<URI> resolve(String curie) {
        StringTokenizer st = new StringTokenizer(curie, ":");
        if (st.countTokens() != 2) {
            return Optional.empty();
        }
        String template = this.mappings.get(st.nextToken());
        if (template == null) {
            return Optional.empty();
        }
        URI resolvedURI = URI.create(template.replace("{rel}", st.nextToken()));
        return Optional.of(resolvedURI);
    }

    public static class Mapping {
        private final String prefix;
        private final String template;

        public Mapping(String prefix, String template) {
            this.prefix = prefix;
            this.template = template;
        }

        public Mapping(Curie curie) {
            this.prefix = curie.prefix();
            this.template = curie.href();
        }
    }
}

