/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openapitools.jackson.dataformat.hal.deser.CurieMap;
import io.openapitools.jackson.dataformat.hal.deser.ReservedProperty;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class HALBeanDeserializer
extends DelegatingDeserializer {
    public HALBeanDeserializer(BeanDeserializerBase delegate) {
        super((JsonDeserializer)delegate);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        TreeNode tn = p.getCodec().readTree(p);
        if (tn.isObject()) {
            ObjectNode root = (ObjectNode)tn;
            for (ReservedProperty rp : ReservedProperty.values()) {
                ObjectNode on = (ObjectNode)tn.get(rp.getPropertyName());
                if (on == null) continue;
                CurieMap curieMap = this.createCurieMap(rp, on);
                on.remove("curies");
                Iterator it = on.fields();
                while (it.hasNext()) {
                    Map.Entry jn = (Map.Entry)it.next();
                    String propertyName = curieMap.resolve((String)jn.getKey()).map(URI::toString).orElse((String)jn.getKey());
                    root.set(rp.alternateName(propertyName), (JsonNode)jn.getValue());
                }
                root.remove(rp.getPropertyName());
            }
        }
        JsonParser modifiedParser = tn.traverse(p.getCodec());
        modifiedParser.nextToken();
        return this._delegatee.deserialize(modifiedParser, ctxt);
    }

    private CurieMap createCurieMap(ReservedProperty rp, ObjectNode on) {
        if (ReservedProperty.LINKS.equals((Object)rp) && on.has("curies")) {
            ArrayNode curies = (ArrayNode)on.get("curies");
            List<CurieMap.Mapping> mappings = StreamSupport.stream(curies.spliterator(), false).map(n -> this.createMapping((ObjectNode)n)).collect(Collectors.toList());
            return new CurieMap(mappings.toArray(new CurieMap.Mapping[0]));
        }
        return new CurieMap(new CurieMap.Mapping[0]);
    }

    private CurieMap.Mapping createMapping(ObjectNode node) {
        return new CurieMap.Mapping(node.get("name").textValue(), node.get("href").textValue());
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new HALBeanDeserializer((BeanDeserializerBase)newDelegatee);
    }
}

