/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.hal;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openapitools.hal.HALAnnotation;
import io.openapitools.hal.HALResourceType;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.AbstractModelConverter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class HALModelConverter
extends AbstractModelConverter {
    public HALModelConverter() {
        this(Json.mapper());
    }

    public HALModelConverter(ObjectMapper mapper) {
        super(mapper);
    }

    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Map properties;
        if (!chain.hasNext()) {
            return null;
        }
        Schema originalSchema = chain.next().resolve(annotatedType, context, chain);
        if (originalSchema == null) {
            return null;
        }
        Schema schema = originalSchema;
        if (originalSchema.get$ref() != null) {
            schema = context.resolve(annotatedType);
        }
        if ((properties = schema.getProperties()) == null) {
            return originalSchema;
        }
        JavaType javaType = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType());
        BeanDescription description = this._mapper.getSerializationConfig().introspect(javaType);
        HALResourceType type = new HALResourceType(description);
        if (!type.isHALResource()) {
            return originalSchema;
        }
        Map<String, Schema> updatedProps = this.updateProperties(properties, type);
        schema.setProperties(updatedProps);
        if (originalSchema.get$ref() != null) {
            context.defineModel(schema.getName(), schema);
        }
        return originalSchema;
    }

    private Map<String, Schema> updateProperties(Map<String, Schema> properties, HALResourceType type) {
        HashMap<String, Schema> updatedProps = new HashMap<String, Schema>();
        properties.forEach((propertyName, propertySchema) -> {
            Optional<Link> annotation = type.getAnnotation(HALAnnotation.LINKS.getAnnotation(), (String)propertyName);
            if (annotation.isPresent()) {
                Schema halSchema = (Schema)updatedProps.getOrDefault(HALAnnotation.LINKS.getName(), (Schema)new ObjectSchema());
                updatedProps.putIfAbsent(HALAnnotation.LINKS.getName(), halSchema);
                String name = HALAnnotation.LINKS.deriveName(type, annotation.get(), (String)propertyName);
                halSchema.addProperties(name, propertySchema);
            } else {
                Optional<EmbeddedResource> embedded = type.getAnnotation(HALAnnotation.EMBEDDED.getAnnotation(), (String)propertyName);
                if (embedded.isPresent()) {
                    Schema halSchema = (Schema)updatedProps.getOrDefault(HALAnnotation.EMBEDDED.getName(), (Schema)new ObjectSchema());
                    updatedProps.putIfAbsent(HALAnnotation.EMBEDDED.getName(), halSchema);
                    String name = HALAnnotation.EMBEDDED.deriveName(type, embedded.get(), (String)propertyName);
                    halSchema.addProperties(name, propertySchema);
                } else {
                    updatedProps.put((String)propertyName, (Schema)propertySchema);
                }
            }
        });
        return updatedProps;
    }
}

