/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;

public class HttpURIBuilder
extends URIBuilder {
    private static ConcurrentMap<String, Integer> SCHEME_DEFAULT_PORT = new ConcurrentHashMap<String, Integer>(){
        {
            this.put("http", 80);
            this.put("https", 443);
        }
    };
    private HttpHost httpHost = null;

    public HttpURIBuilder() {
    }

    public HttpURIBuilder(String string) throws URISyntaxException {
        super(string);
    }

    public HttpURIBuilder(URI uri) {
        super(uri);
    }

    public HttpURIBuilder(String string, Charset charset) throws URISyntaxException {
        super(string, charset);
    }

    public HttpURIBuilder(URI uri, Charset charset) {
        super(uri, charset);
    }

    public int getPort() {
        Integer intVal;
        int port = super.getPort();
        if (port == -1 && (intVal = (Integer)SCHEME_DEFAULT_PORT.get(this.getScheme())) != null) {
            port = intVal;
        }
        return port;
    }

    public HttpHost getHttpHost() {
        if (this.httpHost == null) {
            this.httpHost = new HttpHost(this.getHost(), this.getPort(), this.getScheme());
        }
        return this.httpHost;
    }

    public String getTargetHostURIStr() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getScheme());
        buffer.append("://");
        buffer.append(this.getHost());
        if (this.getPort() != -1) {
            buffer.append(':');
            buffer.append(Integer.toString(this.getPort()));
        }
        return buffer.toString();
    }
}

