/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.utils;

import io.oolon.http.bean.ClientAuthCert;
import io.oolon.http.bean.HttpClientKey;
import io.oolon.http.config.HttpProxySelector;
import io.oolon.http.config.PoolConfig;
import io.oolon.http.config.RequestConfigDelegater;
import io.oolon.http.help.HttpHelper;
import io.oolon.http.utils.RequestConfigUtil;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static ConcurrentHashMap<URI, CloseableHttpClient> normalClientsHolder = new ConcurrentHashMap();
    private static ConcurrentHashMap<HttpClientKey, CloseableHttpClient> clientAuthSSLClientsHolder = new ConcurrentHashMap();
    private static PoolingHttpClientConnectionManager phcm = null;
    private static HttpProxySelector httpProxySelector = null;
    private static PoolConfig poolConfigHolder = null;

    public static HttpClientUtil initPool(PoolConfig poolConfig) {
        if (poolConfig != null) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().setProtocol("TLSv1.2").loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
            }
            catch (KeyManagementException e) {
                logger.error("KeyManagementException:", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("NoSuchAlgorithmException:", (Throwable)e);
            }
            catch (KeyStoreException e) {
                logger.error("KeyStoreException:", (Throwable)e);
            }
            PlainConnectionSocketFactory plainsf = new PlainConnectionSocketFactory();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry connectionSocketFactoryRegistry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
            phcm = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
            phcm.setMaxTotal(poolConfig.getMaxTotal());
            phcm.setDefaultMaxPerRoute(poolConfig.getDefaultMaxPerRoute());
            Map<String, Integer> specRoutes = poolConfig.getSpecHostsMax();
            if (specRoutes != null && specRoutes.size() != 0) {
                for (Map.Entry<String, Integer> entry : specRoutes.entrySet()) {
                    String hostUri = entry.getKey();
                    HttpRoute httpRoute = HttpHelper.getHttpRoute(hostUri, httpProxySelector);
                    phcm.setMaxPerRoute(httpRoute, entry.getValue().intValue());
                }
            }
            poolConfigHolder = poolConfig;
        }
        return null;
    }

    private static PoolingHttpClientConnectionManager genPoolManager(SSLContext sslContext) {
        PoolingHttpClientConnectionManager clientAuthSSLPoolManager = null;
        PoolConfig poolConfig = poolConfigHolder;
        if (poolConfig != null) {
            PlainConnectionSocketFactory plainsf = new PlainConnectionSocketFactory();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry connectionSocketFactoryRegistry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
            clientAuthSSLPoolManager = new PoolingHttpClientConnectionManager(connectionSocketFactoryRegistry);
            int maxConnectionNum = poolConfig.getDefaultMaxPerRoute();
            clientAuthSSLPoolManager.setDefaultMaxPerRoute(poolConfig.getDefaultMaxPerRoute());
            Map<String, Integer> specRoutes = poolConfig.getSpecHostsMax();
            if (specRoutes != null && specRoutes.size() != 0) {
                for (Map.Entry<String, Integer> entry : specRoutes.entrySet()) {
                    String hostUri = entry.getKey();
                    HttpRoute httpRoute = HttpHelper.getHttpRoute(hostUri, httpProxySelector);
                    int specMax = entry.getValue();
                    clientAuthSSLPoolManager.setMaxPerRoute(httpRoute, specMax);
                    maxConnectionNum = specMax > maxConnectionNum ? specMax : maxConnectionNum;
                }
            }
            clientAuthSSLPoolManager.setMaxTotal(maxConnectionNum);
        }
        return clientAuthSSLPoolManager;
    }

    public static HttpClientUtil initProxy(HttpProxySelector httpProxySelector) {
        HttpClientUtil.httpProxySelector = httpProxySelector;
        return null;
    }

    public static CloseableHttpClient getHttpClient(URI uri, ClientAuthCert ... clientAuthCert) throws Exception {
        CloseableHttpClient result = null;
        if (clientAuthCert == null || clientAuthCert.length == 0) {
            result = normalClientsHolder.get(uri);
            if (result == null) {
                HttpHost proxy;
                HttpClientBuilder httpClientBuilder = HttpClients.custom();
                HttpHost target = HttpHelper.getHttpHostByURI(uri);
                if (httpProxySelector != null && (proxy = httpProxySelector.getProxy(target)) != null) {
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                    httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                }
                if (phcm != null) {
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)phcm);
                }
                httpClientBuilder.setConnectionManagerShared(true);
                normalClientsHolder.put(uri, httpClientBuilder.build());
                result = normalClientsHolder.get(uri);
            }
        } else {
            HttpHost target = HttpHelper.getHttpHostByURI(uri);
            HttpClientKey httpClientKey = new HttpClientKey(target, clientAuthCert[0]);
            result = clientAuthSSLClientsHolder.get(httpClientKey);
            if (result == null) {
                HttpHost proxy;
                HttpClientBuilder httpClientBuilder = HttpClients.custom();
                if (httpProxySelector != null && (proxy = httpProxySelector.getProxy(target)) != null) {
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                    httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                }
                KeyStore keyStore = KeyStore.getInstance(clientAuthCert[0].getCertType());
                try (ByteArrayInputStream in = new ByteArrayInputStream(clientAuthCert[0].getKeyStoreByteArr());){
                    keyStore.load(in, clientAuthCert[0].getPassArr());
                }
                SSLContext sslContext = SSLContexts.custom().setProtocol("TLSv1.2").loadKeyMaterial(keyStore, clientAuthCert[0].getPassArr()).loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                if (poolConfigHolder != null) {
                    PoolingHttpClientConnectionManager clientAuthPhcm4ThisUri = HttpClientUtil.genPoolManager(sslContext);
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)clientAuthPhcm4ThisUri);
                } else {
                    httpClientBuilder.setSSLContext(sslContext);
                }
                httpClientBuilder.setConnectionManagerShared(true);
                CloseableHttpClient client4ThisUri = httpClientBuilder.build();
                clientAuthSSLClientsHolder.put(httpClientKey, client4ThisUri);
                result = clientAuthSSLClientsHolder.get(httpClientKey);
            }
        }
        return result;
    }

    public static void setRequestConfigDelegater(RequestConfigDelegater requestConfigDelegater) {
        RequestConfigUtil.setRequestConfigDelegater(requestConfigDelegater);
    }
}

