/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.help;

import io.oolon.http.bean.HttpBean;
import io.oolon.http.config.HttpProxySelector;
import io.oolon.http.utils.HttpURIBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static Logger logger = LoggerFactory.getLogger(HttpHelper.class);

    public static HttpHost getHttpHostByStr(String url) {
        HttpHost target = null;
        if (url != null && url.length() != 0) {
            try {
                HttpURIBuilder httpURIBuilder = new HttpURIBuilder(url);
                target = httpURIBuilder.getHttpHost();
            }
            catch (URISyntaxException e) {
                logger.error("URL + [" + url + "] parse HttpHost Error", (Throwable)e);
            }
        }
        return target;
    }

    public static HttpHost getHttpHostByURI(URI uri) {
        HttpHost target = null;
        if (uri != null) {
            HttpURIBuilder httpURIBuilder = new HttpURIBuilder(uri);
            target = httpURIBuilder.getHttpHost();
        }
        return target;
    }

    public static HttpRoute getHttpRoute(HttpHost target, HttpProxySelector proxySelector) {
        HttpRoute httpRoute = null;
        HttpHost proxy = proxySelector.getProxy(target);
        httpRoute = proxy != null ? new HttpRoute(target, proxy) : new HttpRoute(target);
        return httpRoute;
    }

    public static void addHeader(HttpRequest request, Map<String, String> params) {
        if (request != null && params != null && params.size() != 0) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static HttpRoute getHttpRoute(String url, HttpProxySelector proxySelector) {
        HttpHost target = HttpHelper.getHttpHostByStr(url);
        return HttpHelper.getHttpRoute(target, proxySelector);
    }

    public static HttpPost getHttpPost(URI uri, HttpBean bean) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(uri);
        Map<String, List<String>> headers = bean.getHeaders();
        if (headers != null && headers.size() != 0) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    post.addHeader(entry.getKey(), value);
                }
            }
        }
        String jsonBody = bean.getJsonBody();
        Map<String, List<String>> params = bean.getParameterBody();
        if (jsonBody != null && !"".equals(jsonBody)) {
            StringEntity entityParam = new StringEntity(bean.getJsonBody(), StandardCharsets.UTF_8);
            post.setEntity((HttpEntity)entityParam);
        } else if (params != null && params.size() != 0) {
            ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                for (String value : entry.getValue()) {
                    paramsList.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(paramsList, "UTF-8"));
        }
        return post;
    }

    public static HttpBean getHttpBean(HttpResponse response) throws ParseException, IOException {
        HttpEntity entity;
        HttpBean bean = new HttpBean();
        Header[] heads = response.getAllHeaders();
        if (heads != null && heads.length != 0) {
            HashMap<String, List<String>> headMap = new HashMap<String, List<String>>();
            for (Header head : heads) {
                if (headMap.containsKey(head.getName())) {
                    ((List)headMap.get(head.getName())).add(head.getValue());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(head.getValue());
                headMap.put(head.getName(), list);
            }
            bean.setHeaders(headMap);
        }
        if ((entity = response.getEntity()) != null) {
            bean.setJsonBody(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
        } else {
            bean.setJsonBody("");
        }
        EntityUtils.consume((HttpEntity)entity);
        return bean;
    }
}

