/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.config.impl;

import io.oolon.http.config.RequestConfigDelegater;
import io.oolon.http.utils.HttpURIBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestConfigByProperties
extends RequestConfigDelegater {
    private static Logger logger = LoggerFactory.getLogger(RequestConfigByProperties.class);
    private static ConcurrentHashMap<String, String> properties = null;
    private RequestConfig defaultTimeoutConfig = null;
    private Map<String, RequestConfig> specialTimeoutConfig = null;

    public RequestConfigByProperties() {
        logger.debug("request properties: {}" + properties);
        this.specialTimeoutConfig = new ConcurrentHashMap<String, RequestConfig>();
        Set ketSet = properties.keySet();
        Integer connectionRequestTimeout = null;
        Integer connectTimeout = null;
        Integer socketTimeout = null;
        boolean redirectsEnabled = true;
        for (String name : ketSet) {
            if (name.equals("connectionRequestTimeout")) {
                connectionRequestTimeout = Integer.valueOf(properties.get(name));
                continue;
            }
            if (name.equals("connectTimeout")) {
                connectTimeout = Integer.valueOf(properties.get(name));
                continue;
            }
            if (name.equals("socketTimeout")) {
                socketTimeout = Integer.valueOf(properties.get(name));
                continue;
            }
            if (name.equals("redirectsEnabled")) {
                int i = Integer.valueOf(properties.get(name));
                if (i == 0) {
                    redirectsEnabled = false;
                    continue;
                }
                redirectsEnabled = true;
                continue;
            }
            try {
                String target = new HttpURIBuilder(name).getTargetHostURIStr();
                String requestStr = properties.get(name);
                this.specialTimeoutConfig.put(target, RequestConfigByProperties.genRequestConfigByStr(requestStr));
            }
            catch (URISyntaxException e) {
                logger.error("specail " + name + " parse error", (Throwable)e);
            }
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        if (connectionRequestTimeout != null) {
            builder.setConnectionRequestTimeout(connectionRequestTimeout.intValue());
        }
        if (connectTimeout != null) {
            builder.setConnectTimeout(connectTimeout.intValue());
        }
        if (socketTimeout != null) {
            builder.setSocketTimeout(socketTimeout.intValue());
        }
        builder.setRedirectsEnabled(redirectsEnabled);
        this.defaultTimeoutConfig = builder.build();
    }

    @Override
    public RequestConfig getDefaultRequestConfig() {
        return this.defaultTimeoutConfig;
    }

    @Override
    public Map<String, RequestConfig> getSpecialRequestConfig() {
        return this.specialTimeoutConfig;
    }

    public String toString() {
        return "TimeoutConfigByProperties{defaultTimeoutConfig=" + this.defaultTimeoutConfig + ", specialTimeoutConfig=" + this.specialTimeoutConfig + '}';
    }

    private static RequestConfig genRequestConfigByStr(String str) {
        String[] strArr = str.split(":");
        Integer lConnectionRequestTimeout = null;
        Integer lConnectTimeout = null;
        Integer lSocketTimeout = null;
        int iRedirectsEnabled = 1;
        if (strArr[0] != null && !"".equals(strArr[0])) {
            lConnectionRequestTimeout = Integer.valueOf(strArr[0]);
        }
        if (strArr[1] != null && !"".equals(strArr[1])) {
            lConnectTimeout = Integer.valueOf(strArr[1]);
        }
        if (strArr[2] != null && !"".equals(strArr[2])) {
            lSocketTimeout = Integer.valueOf(strArr[2]);
        }
        if (strArr[3] != null && !"".equals(strArr[3])) {
            iRedirectsEnabled = Integer.valueOf(strArr[3]);
        }
        boolean lRedirectsEnabled = true;
        lRedirectsEnabled = iRedirectsEnabled != 0;
        RequestConfig.Builder builder = RequestConfig.custom();
        if (lConnectionRequestTimeout != null) {
            builder.setConnectionRequestTimeout(lConnectionRequestTimeout.intValue());
        }
        if (lConnectTimeout != null) {
            builder.setConnectTimeout(lConnectTimeout.intValue());
        }
        if (lSocketTimeout != null) {
            builder.setSocketTimeout(lSocketTimeout.intValue());
        }
        builder.setRedirectsEnabled(lRedirectsEnabled);
        return builder.build();
    }

    static {
        properties = new ConcurrentHashMap();
        Properties proxyProperties = new Properties();
        try {
            proxyProperties.load(ClassLoader.getSystemResourceAsStream("request.properties"));
        }
        catch (IOException e) {
            logger.error("request.properties not found:", (Throwable)e);
        }
        Enumeration<?> fileName = proxyProperties.propertyNames();
        while (fileName.hasMoreElements()) {
            String strKey = (String)fileName.nextElement();
            String strValue = proxyProperties.getProperty(strKey);
            properties.put(strKey, strValue);
        }
    }
}

