/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.config.impl;

import io.oolon.http.config.PoolConfig;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolConfigByProperties
implements PoolConfig {
    private static Logger logger = LoggerFactory.getLogger(PoolConfigByProperties.class);
    private static ConcurrentHashMap<String, String> properties = null;
    private int maxTotal = 0;
    private int defaultMaxPerRoute = 0;
    private boolean shareConnection = true;
    private Map<String, Integer> specialPoolConfig = null;
    private static int DEFAULT_MAX_TOTAL;
    private static int DEFAULT_MAX_PERTOUTE;

    public PoolConfigByProperties() {
        logger.debug("pool properties: {}", properties);
        this.specialPoolConfig = new ConcurrentHashMap<String, Integer>();
        Set ketSet = properties.keySet();
        Integer lMaxTotal = null;
        Integer lShareConnection = null;
        Integer lDefaultMaxPerRoute = null;
        for (String name : ketSet) {
            if (name.equals("shareConnection")) {
                lShareConnection = Integer.valueOf(properties.get(name));
                if (lShareConnection == null || lShareConnection == 0) {
                    this.shareConnection = false;
                    continue;
                }
                this.shareConnection = true;
                continue;
            }
            if (name.equals("maxToal")) {
                lMaxTotal = Integer.valueOf(properties.get(name));
                if (lMaxTotal == null || lMaxTotal <= 0) {
                    this.maxTotal = DEFAULT_MAX_TOTAL;
                    continue;
                }
                this.maxTotal = lMaxTotal;
                continue;
            }
            if (name.equals("defaultMaxPerRoute")) {
                lDefaultMaxPerRoute = Integer.valueOf(properties.get(name));
                if (lDefaultMaxPerRoute == null || lDefaultMaxPerRoute <= 0) {
                    this.defaultMaxPerRoute = DEFAULT_MAX_PERTOUTE;
                    continue;
                }
                this.defaultMaxPerRoute = lDefaultMaxPerRoute;
                continue;
            }
            String specialMax = properties.get(name);
            Integer lSpecialMax = Integer.valueOf(specialMax);
            if (lSpecialMax == null || lSpecialMax <= 0) {
                lSpecialMax = DEFAULT_MAX_PERTOUTE;
            }
            this.specialPoolConfig.put(name, lSpecialMax);
        }
    }

    @Override
    public int getMaxTotal() {
        return this.maxTotal;
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    @Override
    public Map<String, Integer> getSpecHostsMax() {
        return null;
    }

    static {
        properties = new ConcurrentHashMap();
        Properties proxyProperties = new Properties();
        try {
            proxyProperties.load(ClassLoader.getSystemResourceAsStream("pool.properties"));
        }
        catch (IOException e) {
            logger.error("pool.properties not found:", (Throwable)e);
        }
        Enumeration<?> keyName = proxyProperties.propertyNames();
        while (keyName.hasMoreElements()) {
            String strKey = (String)keyName.nextElement();
            String strValue = proxyProperties.getProperty(strKey);
            properties.put(strKey, strValue);
        }
        DEFAULT_MAX_TOTAL = 400;
        DEFAULT_MAX_PERTOUTE = 20;
    }
}

