/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http.config.impl;

import io.oolon.http.config.HttpProxySelector;
import io.oolon.http.utils.HttpURIBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxySelectorByProperties
extends HttpProxySelector {
    private static Logger logger = LoggerFactory.getLogger(HttpProxySelectorByProperties.class);
    private static ConcurrentHashMap<String, String> properties = null;
    protected HttpHost defaultProxy = null;
    protected Map<HttpHost, HttpHost> specialProxyMap = null;
    protected Set<HttpHost> ignoreHosts = null;

    public HttpProxySelectorByProperties() {
        logger.debug("proxy properties:{}", (Object)properties.toString());
        this.specialProxyMap = new ConcurrentHashMap<HttpHost, HttpHost>();
        this.ignoreHosts = ConcurrentHashMap.newKeySet();
        Set ketSet = properties.keySet();
        for (String name : ketSet) {
            if (name.equals("defaultProxy")) {
                try {
                    this.defaultProxy = new HttpURIBuilder(properties.get(name)).getHttpHost();
                }
                catch (URISyntaxException e) {
                    logger.error("defaultProxy parse error:", (Throwable)e);
                }
                continue;
            }
            if (name.equals("ignoreHosts")) {
                String[] ignores;
                for (String s : ignores = properties.get(name).split(";")) {
                    try {
                        this.ignoreHosts.add(new HttpURIBuilder(s).getHttpHost());
                    }
                    catch (URISyntaxException e) {
                        logger.error("ignoreHosts parse error:", (Throwable)e);
                    }
                }
                continue;
            }
            try {
                HttpHost target = new HttpURIBuilder(name).getHttpHost();
                HttpHost proxy = new HttpURIBuilder(properties.get(name)).getHttpHost();
                this.specialProxyMap.put(target, proxy);
            }
            catch (URISyntaxException e) {
                logger.error("specail " + name + " parse error", (Throwable)e);
            }
        }
    }

    @Override
    protected HttpHost getDefaultProxy() {
        return this.defaultProxy;
    }

    @Override
    protected Map<HttpHost, HttpHost> getSpecialProxyMap() {
        return this.specialProxyMap;
    }

    @Override
    protected Set<HttpHost> getIgnoreHosts() {
        return this.ignoreHosts;
    }

    public String toString() {
        return "HttpProxySelectorByProperties{defaultProxy=" + this.defaultProxy + ", specialProxyMap=" + this.specialProxyMap + ", ignoreHosts=" + this.ignoreHosts + '}';
    }

    static {
        properties = new ConcurrentHashMap();
        Properties proxyProperties = new Properties();
        try {
            proxyProperties.load(ClassLoader.getSystemResourceAsStream("proxy.properties"));
        }
        catch (IOException e) {
            logger.error("proxy.properties not found", (Throwable)e);
        }
        Enumeration<?> fileName = proxyProperties.propertyNames();
        while (fileName.hasMoreElements()) {
            String strKey = (String)fileName.nextElement();
            String strValue = proxyProperties.getProperty(strKey);
            properties.put(strKey, strValue);
        }
    }
}

