/*
 * Decompiled with CFR 0.152.
 */
package io.oolon.http;

import io.oolon.http.bean.ClientAuthCert;
import io.oolon.http.bean.HttpBean;
import io.oolon.http.help.HttpHelper;
import io.oolon.http.utils.HttpClientUtil;
import io.oolon.http.utils.HttpURIBuilder;
import io.oolon.http.utils.RequestConfigUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static String doGet(String url, ClientAuthCert ... clientAuthCert) throws URISyntaxException {
        return HttpUtil.doGet(url, (List<NameValuePair>)null, clientAuthCert);
    }

    public static String doGet(String url, List<NameValuePair> params, ClientAuthCert ... clientAuthCert) throws URISyntaxException {
        HttpURIBuilder uriBuilder = new HttpURIBuilder(url, StandardCharsets.UTF_8);
        if (params != null) {
            uriBuilder.setParameters(params);
        }
        URI uri = uriBuilder.build();
        HttpGet httpGet = new HttpGet(uri);
        RequestConfigUtil.setRequestConfigForRequest((HttpRequestBase)httpGet, uriBuilder.getTargetHostURIStr());
        String returnStr = "";
        try (CloseableHttpClient client = HttpClientUtil.getHttpClient(uri, clientAuthCert);
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                returnStr = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5931\u8d25 URL [" + url + "] \u53c2\u6570 [" + params + "]\n", (Throwable)e);
        }
        return returnStr;
    }

    public static String doGet(String url, Map<String, String> params, ClientAuthCert ... clientAuthCert) throws URISyntaxException {
        ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
        if (params != null && params.size() != 0) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramsList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        if (paramsList.size() == 0) {
            paramsList = null;
        }
        return HttpUtil.doGet(url, paramsList, clientAuthCert);
    }

    public static String doPost(String url, String json, ClientAuthCert ... clientAuthCert) throws URISyntaxException {
        HttpURIBuilder uriBuilder = new HttpURIBuilder(url, StandardCharsets.UTF_8);
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        RequestConfigUtil.setRequestConfigForRequest((HttpRequestBase)httpPost, uriBuilder.getTargetHostURIStr());
        StringEntity entityParam = new StringEntity(json, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entityParam);
        String returnStr = "";
        try (CloseableHttpClient client = HttpClientUtil.getHttpClient(uri, clientAuthCert);
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                returnStr = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5931\u8d25 URL [" + url + "] JSON [" + json + "]\n", (Throwable)e);
        }
        return returnStr;
    }

    public static String doPost(String url, String json, Map<String, String> headers, ClientAuthCert ... clientAuthCert) throws URISyntaxException {
        HttpURIBuilder uriBuilder = new HttpURIBuilder(url, StandardCharsets.UTF_8);
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        RequestConfigUtil.setRequestConfigForRequest((HttpRequestBase)httpPost, uriBuilder.getTargetHostURIStr());
        HttpHelper.addHeader((HttpRequest)httpPost, headers);
        StringEntity entityParam = new StringEntity(json, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entityParam);
        String returnStr = "";
        try (CloseableHttpClient client = HttpClientUtil.getHttpClient(uri, clientAuthCert);
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                returnStr = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5931\u8d25 URL [" + url + "] JSON [" + json + "]\n", (Throwable)e);
        }
        return returnStr;
    }

    public static String doPost(String url, List<NameValuePair> params, ClientAuthCert ... clientAuthCert) throws UnsupportedEncodingException, URISyntaxException {
        HttpURIBuilder uriBuilder = new HttpURIBuilder(url, StandardCharsets.UTF_8);
        URI uri = uriBuilder.build();
        HttpPost httpPost = new HttpPost(uri);
        RequestConfigUtil.setRequestConfigForRequest((HttpRequestBase)httpPost, uriBuilder.getTargetHostURIStr());
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        String returnStr = "";
        try (CloseableHttpClient client = HttpClientUtil.getHttpClient(uri, clientAuthCert);
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                returnStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5931\u8d25 URL [" + url + "] \u53c3\u6578 [" + params + "]\n", (Throwable)e);
        }
        return returnStr;
    }

    public static HttpBean doPost(String url, HttpBean request, ClientAuthCert ... clientAuthCert) throws Exception {
        HttpURIBuilder uriBuilder = new HttpURIBuilder(url, StandardCharsets.UTF_8);
        URI uri = uriBuilder.build();
        HttpPost httpPost = HttpHelper.getHttpPost(uri, request);
        RequestConfigUtil.setRequestConfigForRequest((HttpRequestBase)httpPost, uriBuilder.getTargetHostURIStr());
        HttpBean responseBean = null;
        try (CloseableHttpClient client = HttpClientUtil.getHttpClient(uri, clientAuthCert);
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            responseBean = HttpHelper.getHttpBean((HttpResponse)response);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5931\u8d25 URL [" + url + "] \u53c3\u6578 [" + request + "]\n", (Throwable)e);
        }
        return responseBean;
    }
}

