package io.nlopez.loom.compose.hilt.navigation

import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.LocalContext
import androidx.hilt.navigation.HiltViewModelFactory
import androidx.navigation.NavBackStackEntry
import io.nlopez.loom.LoomViewModel
import io.nlopez.loom.compose.loomViewModel

/**
 * Instantiates a [LoomViewModel] scoped to a [NavBackStackEntry].
 */
@Composable
public inline fun <reified VM : LoomViewModel<out Any, *>> NavBackStackEntry.loomViewModel(
  named: String? = null
): VM = loomViewModel(
  named = named,
  factory = HiltViewModelFactory(LocalContext.current, this)
)
