/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel.factory;

import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.AbstractChannelFactory;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import java.io.File;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TlsChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    private static final Logger log = LoggerFactory.getLogger(TlsChannelFactory.class);

    public TlsChannelFactory(GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        super(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name, GrpcClientProperties clientProperties) {
        SslContext sslContext;
        String host = clientProperties.getHost();
        int port = clientProperties.getPort();
        String trustCertCollectionFilePath = clientProperties.getTrustCertCollectionFilePath();
        if (!StringUtils.hasText((String)host)) {
            log.error("please config required property [host] for Tls model");
            throw new RuntimeException("Failed to create Tls channel");
        }
        if (!StringUtils.hasText((String)trustCertCollectionFilePath)) {
            log.error("please config required property [trustCertCollectionFilePath] for Tls model");
            throw new RuntimeException("Failed to create Tls channel");
        }
        log.info("will create channel with tls");
        log.info("creating channel on {}:{}", (Object)host, (Object)port);
        try {
            sslContext = TlsChannelFactory.buildSslContext(trustCertCollectionFilePath, null, null);
        }
        catch (SSLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port).negotiationType(NegotiationType.TLS).sslContext(sslContext);
        return nettyChannelBuilder;
    }

    private static SslContext buildSslContext(String trustCertCollectionFilePath, String clientCertChainFilePath, String clientPrivateKeyFilePath) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        if (trustCertCollectionFilePath != null) {
            builder.trustManager(new File(trustCertCollectionFilePath));
        }
        if (clientCertChainFilePath != null && clientPrivateKeyFilePath != null) {
            builder.keyManager(new File(clientCertChainFilePath), new File(clientPrivateKeyFilePath));
        }
        builder.protocols(new String[]{"TLSv1.2"});
        return builder.build();
    }
}

