/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel.factory;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.nity.grpc.client.channel.DisposableManagedChannel;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.CustomChannelFactory;
import io.nity.grpc.client.channel.factory.GrpcChannelFactory;
import io.nity.grpc.client.channel.factory.InProcessChannelFactory;
import io.nity.grpc.client.channel.factory.SimpleChannelFactory;
import io.nity.grpc.client.channel.factory.TlsChannelFactory;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class GrpcChannelFactoryFacede
implements GrpcChannelFactory {
    private GrpcClientPropertiesMap clientPropertiesMap;
    private final GrpcChannelFactory inProcessChannelFactory;
    private final GrpcChannelFactory simpleChannelFactory;
    private final GrpcChannelFactory tlsChannelFactory;
    private final GrpcChannelFactory customChannelFactory;

    public GrpcChannelFactoryFacede(ApplicationContext applicationContext, GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        this.clientPropertiesMap = clientPropertiesMap;
        this.inProcessChannelFactory = new InProcessChannelFactory(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
        this.simpleChannelFactory = new SimpleChannelFactory(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
        this.tlsChannelFactory = new TlsChannelFactory(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
        this.customChannelFactory = (GrpcChannelFactory)applicationContext.getBean(CustomChannelFactory.class);
    }

    @Override
    public ManagedChannel createChannel(String name, List<ClientInterceptor> interceptors) {
        ManagedChannel channel;
        GrpcClientProperties clientProperties = this.clientPropertiesMap.getClient(name);
        if ("inProcess".equals(clientProperties.getModel())) {
            channel = this.inProcessChannelFactory.createChannel(name, interceptors);
        } else if ("simple".equals(clientProperties.getModel())) {
            channel = this.simpleChannelFactory.createChannel(name, interceptors);
        } else if ("tls".equals(clientProperties.getModel())) {
            channel = this.tlsChannelFactory.createChannel(name, interceptors);
        } else if ("custom".equals(clientProperties.getModel())) {
            channel = this.customChannelFactory.createChannel(name, interceptors);
        } else {
            throw new RuntimeException("Failed to create GrpcClient for name:" + name);
        }
        DisposableManagedChannel disposableManagedChannel = new DisposableManagedChannel(channel);
        return disposableManagedChannel;
    }

    @Override
    public void close() {
    }
}

