/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel.factory;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.GrpcChannelFactory;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelFactory<T extends ManagedChannelBuilder<T>>
implements GrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelFactory.class);
    private final GrpcClientPropertiesMap clientPropertiesMap;
    protected final GrpcChannelBuilderConfigurer channelBuilderConfigurer;
    protected final GrpcChannelConfigurer channelConfigurer;
    @GuardedBy(value="this")
    private final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private boolean shutdown = false;

    public AbstractChannelFactory(GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        this.clientPropertiesMap = Objects.requireNonNull(clientPropertiesMap, "clientPropertiesMap");
        this.channelBuilderConfigurer = Objects.requireNonNull(channelBuilderConfigurer, "channelBuilderConfigurer");
        this.channelConfigurer = Objects.requireNonNull(channelConfigurer, "channelConfigurer");
    }

    @Override
    public final ManagedChannel createChannel(String name) {
        return this.createChannel(name, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedChannel createChannel(String name, List<ClientInterceptor> customInterceptors) {
        ManagedChannel channel;
        AbstractChannelFactory abstractChannelFactory = this;
        synchronized (abstractChannelFactory) {
            if (this.shutdown) {
                throw new IllegalStateException("GrpcChannelFactory is already closed!");
            }
            channel = this.channels.computeIfAbsent(name, this::newManagedChannel);
        }
        ArrayList interceptors = Lists.newArrayList();
        if (!customInterceptors.isEmpty()) {
            interceptors.addAll(customInterceptors);
        }
        ClientInterceptors.intercept((Channel)channel, (List)interceptors);
        return channel;
    }

    protected abstract T newChannelBuilder(String var1, GrpcClientProperties var2);

    protected ManagedChannel newManagedChannel(String name) {
        GrpcClientProperties clientProperties = this.getPropertiesFor(name);
        T builder = this.newChannelBuilder(name, clientProperties);
        this.configure(builder, name);
        ManagedChannel channel = builder.build();
        this.channelConfigurer.configure((Channel)channel, name);
        return channel;
    }

    protected final GrpcClientProperties getPropertiesFor(String name) {
        return this.clientPropertiesMap.getClient(name);
    }

    protected void configure(T builder, String name) {
        this.channelBuilderConfigurer.configure((ManagedChannelBuilder<?>)builder, name);
    }

    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
    }
}

