/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.autoconfigure;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.nity.grpc.DisposableManagedChannel;
import io.nity.grpc.autoconfigure.GrpcClientProperties;
import java.io.File;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfigureOrder
public class GrpcClientTlsAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientTlsAutoConfiguration.class);
    @Autowired
    private GrpcClientProperties clientProperties;

    @Bean
    @ConditionalOnProperty(value={"grpc.client.model"}, havingValue="tls")
    public DisposableManagedChannel getChannel() throws SSLException {
        int port = this.clientProperties.getPort();
        String host = this.clientProperties.getHost();
        String trustCertCollectionFilePath = this.clientProperties.getTrustCertCollectionFilePath();
        if (!StringUtils.hasText((String)host)) {
            log.error("please config required property [host] for Tls model");
            throw new RuntimeException("Failed to create Tls channel");
        }
        if (!StringUtils.hasText((String)trustCertCollectionFilePath)) {
            log.error("please config required property [trustCertCollectionFilePath] for Tls model");
            throw new RuntimeException("Failed to create Tls channel");
        }
        log.info("will create channel with tls");
        log.info("creating channel on {}:{}", (Object)host, (Object)port);
        SslContext sslContext = GrpcClientTlsAutoConfiguration.buildSslContext(trustCertCollectionFilePath, null, null);
        ManagedChannel channel = NettyChannelBuilder.forAddress((String)host, (int)port).negotiationType(NegotiationType.TLS).sslContext(sslContext).build();
        DisposableManagedChannel disposableManagedChannel = new DisposableManagedChannel(channel);
        return disposableManagedChannel;
    }

    private static SslContext buildSslContext(String trustCertCollectionFilePath, String clientCertChainFilePath, String clientPrivateKeyFilePath) throws SSLException {
        SslContextBuilder builder = GrpcSslContexts.forClient();
        if (trustCertCollectionFilePath != null) {
            builder.trustManager(new File(trustCertCollectionFilePath));
        }
        if (clientCertChainFilePath != null && clientPrivateKeyFilePath != null) {
            builder.keyManager(new File(clientCertChainFilePath), new File(clientPrivateKeyFilePath));
        }
        builder.protocols(new String[]{"TLSv1.2"});
        return builder.build();
    }
}

