/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client.retry;

import io.nextop.client.retry.RandomSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public interface SendStrategy {
    public static final SendStrategy INDEFINITE = new Builder().init(0L, TimeUnit.MILLISECONDS).withUniformRandom(1L, TimeUnit.SECONDS).repeat(5).withUniformRandom(10L, TimeUnit.SECONDS).repeatIndefinitely().build();
    public static final SendStrategy MAX_30S = new Builder().init(0L, TimeUnit.MILLISECONDS).withLinearRandom(5L, TimeUnit.SECONDS).repeat(3).build();

    public boolean test();

    public long delay(TimeUnit var1);

    public SendStrategy retry();

    public static final class Builder {
        private Node head = new Node();
        private List<Node> sequence = new ArrayList<Node>(4);

        public Builder init(long delay, TimeUnit timeUnit) {
            this.head.type = Node.Type.UNIFORM;
            this.head.initMs = timeUnit.toMillis(delay);
            return this;
        }

        public Builder max(long delay, TimeUnit timeUnit) {
            this.head.maxMs = timeUnit.toMillis(delay);
            return this;
        }

        public Builder withUniformRandom(long delay, TimeUnit timeUnit) {
            this.head.type = Node.Type.UNIFORM_RANDOM;
            this.head.delayMs = timeUnit.toMillis(delay);
            return this;
        }

        public Builder withLinearRandom(long delayPerStep, TimeUnit timeUnit) {
            this.head.type = Node.Type.LINEAR_RANDOM;
            this.head.delayMs = timeUnit.toMillis(delayPerStep);
            return this;
        }

        public Builder withExponentialRandom(float factorPerStep) {
            this.head.type = Node.Type.LINEAR_RANDOM;
            this.head.factor = factorPerStep;
            return this;
        }

        public Builder repeat(int count) {
            if (count < 0) {
                throw new IllegalArgumentException();
            }
            this.head.count = count;
            this.sequence.add(new Node(this.head));
            this.head.count = 0;
            return this;
        }

        public Builder repeatIndefinitely() {
            return this.repeat(Integer.MAX_VALUE);
        }

        public SendStrategy build() {
            if (this.sequence.isEmpty()) {
                throw new IllegalStateException();
            }
            SendStrategy tail = null;
            for (int i = this.sequence.size() - 1; 0 <= i; --i) {
                tail = this.create(this.sequence.get(i), tail);
            }
            return tail;
        }

        SendStrategy create(Node node, @Nullable SendStrategy after) {
            switch (node.type) {
                case UNIFORM: {
                    return new UniformSendStrategy(node.initMs, node.maxMs, node.count, after);
                }
                case UNIFORM_RANDOM: {
                    return new UniformRandomSendStrategy(node.initMs, node.maxMs, node.count, after, node.delayMs, RandomSequence.create(new Random()));
                }
                case LINEAR_RANDOM: {
                    return new LinearRandomSendStrategy(node.initMs, node.maxMs, node.count, after, node.delayMs, RandomSequence.create(new Random()));
                }
                case EXPONENTIAL_RANDOM: {
                    return new ExponentialRandomSendStrategy(node.initMs, node.maxMs, node.count, after, node.factor, RandomSequence.create(new Random()));
                }
            }
            throw new IllegalArgumentException();
        }

        private static final class ExponentialRandomSendStrategy
        extends AbstractSendStrategy {
            float factor;
            RandomSequence r;

            ExponentialRandomSendStrategy(long initMs, long maxMs, int countDown, @Nullable SendStrategy after, float factor, RandomSequence r) {
                super(initMs, maxMs, countDown, after);
                this.factor = factor;
                this.r = r;
            }

            @Override
            public long delay(TimeUnit timeUnit) {
                return Math.min(TimeUnit.MILLISECONDS.convert(Math.round(this.r.floatValue() * (float)this.initMs * this.factor), timeUnit), TimeUnit.MILLISECONDS.convert(this.maxMs, timeUnit));
            }

            @Override
            public SendStrategy retry() {
                if (1 < this.countDown) {
                    return new ExponentialRandomSendStrategy(Math.round(this.r.floatValue() * (float)this.initMs * this.factor), this.maxMs, this.countDown - 1, this.after, this.factor, this.r);
                }
                return this.after;
            }
        }

        private static final class LinearRandomSendStrategy
        extends AbstractSendStrategy {
            long delayMs;
            RandomSequence r;

            LinearRandomSendStrategy(long initMs, long maxMs, int countDown, @Nullable SendStrategy after, long delayMs, RandomSequence r) {
                super(initMs, maxMs, countDown, after);
                this.delayMs = delayMs;
                this.r = r;
            }

            @Override
            public long delay(TimeUnit timeUnit) {
                return Math.min(TimeUnit.MILLISECONDS.convert(this.initMs + (long)Math.round(this.r.floatValue() * (float)this.delayMs), timeUnit), TimeUnit.MILLISECONDS.convert(this.maxMs, timeUnit));
            }

            @Override
            public SendStrategy retry() {
                if (1 < this.countDown) {
                    return new LinearRandomSendStrategy(this.initMs + (long)Math.round(this.r.floatValue() * (float)this.delayMs), this.maxMs, this.countDown - 1, this.after, this.delayMs, this.r);
                }
                return this.after;
            }
        }

        private static final class UniformRandomSendStrategy
        extends AbstractSendStrategy {
            long delayMs;
            RandomSequence r;

            UniformRandomSendStrategy(long initMs, long maxMs, int countDown, @Nullable SendStrategy after, long delayMs, RandomSequence r) {
                super(initMs, maxMs, countDown, after);
                this.delayMs = delayMs;
                this.r = r;
            }

            @Override
            public long delay(TimeUnit timeUnit) {
                return Math.min(TimeUnit.MILLISECONDS.convert(this.initMs + (long)Math.round(this.r.floatValue() * (float)this.delayMs), timeUnit), TimeUnit.MILLISECONDS.convert(this.maxMs, timeUnit));
            }

            @Override
            public SendStrategy retry() {
                if (1 < this.countDown) {
                    return new UniformRandomSendStrategy(this.initMs, this.maxMs, this.countDown - 1, this.after, this.delayMs, this.r);
                }
                return this.after;
            }
        }

        private static final class UniformSendStrategy
        extends AbstractSendStrategy {
            UniformSendStrategy(long initMs, long maxMs, int countDown, @Nullable SendStrategy after) {
                super(initMs, maxMs, countDown, after);
            }

            @Override
            public long delay(TimeUnit timeUnit) {
                return Math.min(TimeUnit.MILLISECONDS.convert(this.initMs, timeUnit), TimeUnit.MILLISECONDS.convert(this.maxMs, timeUnit));
            }

            @Override
            public SendStrategy retry() {
                if (0 < this.countDown) {
                    return new UniformSendStrategy(this.initMs, this.maxMs, this.countDown - 1, this.after);
                }
                return this.after;
            }
        }

        private static abstract class AbstractSendStrategy
        implements SendStrategy {
            int countDown;
            long initMs;
            long maxMs;
            @Nullable
            SendStrategy after;

            AbstractSendStrategy(long initMs, long maxMs, int countDown, @Nullable SendStrategy after) {
                this.initMs = initMs;
                this.maxMs = maxMs;
                this.countDown = countDown;
                this.after = after;
            }

            @Override
            public boolean test() {
                return 0 < this.countDown;
            }
        }

        private static final class Node {
            Type type;
            long initMs;
            long maxMs;
            long delayMs;
            float factor;
            int count;

            Node() {
                this.type = Type.UNIFORM;
                this.initMs = 0L;
                this.maxMs = -1L;
                this.delayMs = 0L;
                this.factor = 1.0f;
                this.count = 0;
            }

            Node(Node copy) {
                this.type = copy.type;
                this.initMs = copy.initMs;
                this.maxMs = copy.maxMs;
                this.delayMs = copy.delayMs;
                this.factor = copy.factor;
                this.count = copy.count;
            }

            static enum Type {
                UNIFORM,
                UNIFORM_RANDOM,
                LINEAR_RANDOM,
                EXPONENTIAL_RANDOM;

            }
        }
    }
}

