/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlChannel;
import io.nextop.client.MessageControlMetrics;
import io.nextop.client.MessageControlState;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MessageContext
implements MessageControlChannel {
    private final MessageControlState mcs;
    private final ScheduledExecutorService executor;

    public MessageContext(MessageControlState mcs) {
        this.mcs = mcs;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void post(Runnable r) {
        this.executor.execute(r);
    }

    @Override
    public void postDelayed(Runnable r, int delayMs) {
        this.executor.schedule(r, (long)delayMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onActive(boolean active, MessageControlMetrics metrics) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onTransfer(MessageControlState mcs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onMessageControl(MessageControl mc) {
        throw new UnsupportedOperationException();
    }
}

