/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import io.nextop.Message;
import io.nextop.Route;
import io.nextop.client.AbstractMessageControlNode;
import io.nextop.client.MessageControl;
import io.nextop.client.MessageControlMetrics;
import io.nextop.client.MessageControlState;
import io.nextop.client.retry.SendStrategy;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpNode
extends AbstractMessageControlNode {
    private Executor executor;
    private HttpClient httpClient;
    private SendStrategy sendStrategy = SendStrategy.INDEFINITE;

    public HttpNode() {
        this(Executors.newSingleThreadExecutor());
    }

    public HttpNode(Executor executor) {
        this.executor = executor;
        this.httpClient = new DefaultHttpClient();
    }

    @Override
    public void onActive(boolean active, MessageControlMetrics metrics) {
    }

    @Override
    public void onTransfer(MessageControlState mcs) {
    }

    @Override
    public void onMessageControl(MessageControl mc) {
        switch (mc.type) {
            case SEND: {
                this.onSend(mc.message);
                break;
            }
            case SUBSCRIBE: {
                break;
            }
            case UNSUBSCRIBE: {
                break;
            }
            case SEND_NACK: {
                break;
            }
            case RECEIVE_ACK: {
                break;
            }
        }
    }

    private void onSend(Message message) {
        if (!message.route.via.isLocal()) {
            this.executor.execute(new RequestWorker(message));
        }
    }

    private void onSendError(Message message) {
        this.upstream.onMessageControl(new MessageControl(MessageControl.Type.SEND_ERROR, message));
    }

    private void onReceive(Message message) {
        this.upstream.onMessageControl(new MessageControl(MessageControl.Type.RECEIVE, message));
    }

    private void onReceiveError(Message message) {
        this.upstream.onMessageControl(new MessageControl(MessageControl.Type.RECEIVE_ERROR, message));
    }

    private static final class TransferProgressState {
        final Route route;
        float progress;

        TransferProgressState(Route route, float progress) {
            this.route = route;
            this.progress = progress;
        }
    }

    private final class RequestWorker
    implements Runnable {
        final Message requestMessage;

        RequestWorker(Message requestMessage) {
            this.requestMessage = requestMessage;
        }

        @Override
        public void run() {
            Message responseMessage;
            HttpResponse response;
            HttpUriRequest request;
            try {
                request = Message.toHttpRequest(this.requestMessage);
            }
            catch (Exception e) {
                HttpNode.this.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpNode.this.onSendError(RequestWorker.this.requestMessage);
                    }
                });
                return;
            }
            try {
                response = HttpNode.this.httpClient.execute(request);
            }
            catch (Exception e) {
                HttpNode.this.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpNode.this.onSendError(RequestWorker.this.requestMessage);
                    }
                });
                return;
            }
            try {
                responseMessage = Message.fromHttpResponse(response).setRoute(this.requestMessage.inboxRoute()).build();
            }
            catch (Exception e) {
                HttpNode.this.post(new Runnable(){

                    @Override
                    public void run() {
                        HttpNode.this.onReceiveError(Message.newBuilder().setRoute(RequestWorker.this.requestMessage.inboxRoute()).build());
                    }
                });
                return;
            }
            HttpNode.this.post(new Runnable(){

                @Override
                public void run() {
                    HttpNode.this.onReceive(responseMessage);
                }
            });
        }
    }
}

