/*
 * Decompiled with CFR 0.152.
 */
package io.nextop.client;

import io.nextop.client.MessageControlChannel;
import io.nextop.client.MessageControlNode;
import javax.annotation.Nullable;

public abstract class AbstractMessageControlNode
implements MessageControlNode {
    @Nullable
    protected MessageControlChannel upstream = null;

    private void checkUpstream() {
        if (null == this.upstream) {
            throw new IllegalStateException();
        }
    }

    protected void initSelf() {
    }

    protected void initDownstream() {
    }

    protected void startSelf() {
    }

    protected void startDownstream() {
    }

    protected void stopSelf() {
    }

    protected void stopDownstream() {
    }

    @Override
    public final void init(MessageControlChannel upstream) {
        if (null != this.upstream) {
            throw new IllegalStateException();
        }
        this.upstream = upstream;
        this.initSelf();
        this.initDownstream();
    }

    @Override
    public final void start() {
        this.checkUpstream();
        this.startDownstream();
        this.startSelf();
    }

    @Override
    public final void stop() {
        this.checkUpstream();
        this.stopDownstream();
        this.stopSelf();
    }

    @Override
    public void post(Runnable r) {
        this.checkUpstream();
        this.upstream.post(r);
    }

    @Override
    public void postDelayed(Runnable r, int delayMs) {
        this.checkUpstream();
        this.upstream.postDelayed(r, delayMs);
    }
}

