/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import io.nextop.Authority;
import io.nextop.Id;
import io.nextop.Path;
import javax.annotation.Nullable;

public final class Route {
    public static final Via LOCAL = new Via(Scheme.NEXTOP, Authority.local());
    public final Target target;
    public final Via via;

    public static Route valueOf(String s) {
        int n = s.length();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int i = s.indexOf(32);
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        String d = "://";
        int j = s.indexOf(d, i + 1);
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        int k = s.indexOf(47, j + d.length());
        Method method = Method.valueOf(s.substring(0, i).toUpperCase());
        Via via = Via.valueOf(s.substring(i + 1, k));
        Path path = k < 0 ? Path.empty() : Path.valueOf(s.substring(k + 1, n));
        return new Route(new Target(method, path), via);
    }

    public static Route create(Target target, Via via) {
        return new Route(target, via);
    }

    public static Route local(Target target) {
        return new Route(target, LOCAL);
    }

    private Route(Target target, Via via) {
        this.target = target;
        this.via = via;
    }

    @Nullable
    public Id getLocalId() {
        if (this.via.isLocal() && this.target.path.isFixed() && 1 <= this.target.path.segments.size()) {
            Path.Segment first = this.target.path.segments.get(0);
            assert (Path.Segment.Type.FIXED.equals((Object)first.type));
            try {
                return Id.valueOf(first.value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return String.format("%s %s%s", new Object[]{this.target.method, this.via, this.target.path});
    }

    public int hashCode() {
        int c = this.target.hashCode();
        c = 31 * c + this.via.hashCode();
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Route)) {
            return false;
        }
        Route b = (Route)obj;
        return this.target.equals(b.target) && this.via.equals(b.via);
    }

    public static class Via {
        public final Scheme scheme;
        public final Authority authority;

        public static Via valueOf(String s) {
            String d = "://";
            int n = s.length();
            int i = s.indexOf(d);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            Scheme scheme = Scheme.valueOf(s.substring(0, i).toUpperCase());
            Authority authority = Authority.valueOf(s.substring(i + d.length(), n));
            return new Via(scheme, authority);
        }

        public static Via create(Scheme scheme, Authority authority) {
            return new Via(scheme, authority);
        }

        private Via(Scheme scheme, Authority authority) {
            this.scheme = scheme;
            this.authority = authority;
        }

        public boolean isLocal() {
            return LOCAL.equals(this);
        }

        public String toString() {
            return String.format("%s://%s", this.scheme.toString().toLowerCase(), this.authority);
        }

        public int hashCode() {
            int c = this.scheme.hashCode();
            c = 31 * c + this.authority.hashCode();
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Via)) {
                return false;
            }
            Via b = (Via)obj;
            return this.scheme.equals((Object)b.scheme) && this.authority.equals(b.authority);
        }
    }

    public static class Target {
        public final Method method;
        public final Path path;

        public static Target valueOf(String s) {
            int n = s.length();
            int i = s.indexOf(32);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            Method method = Method.valueOf(s.substring(0, i).toUpperCase());
            Path path = Path.valueOf(s.substring(i + 1, n));
            return new Target(method, path);
        }

        public static Target create(Method method, Path path) {
            return new Target(method, path);
        }

        private Target(Method method, Path path) {
            this.method = method;
            this.path = path;
        }

        public String toString() {
            return String.format("%s %s", new Object[]{this.method, this.path});
        }

        public int hashCode() {
            int c = this.method.hashCode();
            c = 31 * c + this.path.hashCode();
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Target)) {
                return false;
            }
            Target b = (Target)obj;
            return this.method.equals((Object)b.method) && this.path.equals(b.path);
        }
    }

    public static enum Scheme {
        HTTP,
        HTTPS,
        NEXTOP;

    }

    public static enum Method {
        GET,
        HEAD,
        POST,
        PUT;

    }
}

