/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import rx.functions.Func1;

public class Path {
    public final List<Segment> segments;

    public static Path valueOf(String s) {
        int n = s.length();
        int j = 0 < n && '/' == s.charAt(0) ? 1 : 0;
        LinkedList<Segment> segments = new LinkedList<Segment>();
        for (int i = j; i < n; ++i) {
            char c = s.charAt(i);
            if ('?' == c || '#' == c) {
                segments.add(Segment.valueOf(s.substring(j, i)));
                j = n;
                break;
            }
            if ('/' != c) continue;
            segments.add(Segment.valueOf(s.substring(j, i)));
            j = i + 1;
        }
        if (j < n) {
            segments.add(Segment.valueOf(s.substring(j, n)));
        }
        return new Path((List<Segment>)ImmutableList.copyOf(segments));
    }

    public static Path empty() {
        return new Path(Collections.<Segment>emptyList());
    }

    private Path(List<Segment> segments) {
        this.segments = segments;
    }

    public boolean isFixed() {
        for (Segment segment : this.segments) {
            if (Segment.Type.FIXED.equals((Object)segment.type)) continue;
            return false;
        }
        return true;
    }

    public Path fix(Func1<String, Object> subs) throws URISyntaxException {
        int n = this.segments.size();
        ArrayList<Segment> fixedSegments = new ArrayList<Segment>(n);
        block6: for (int i = 0; i < n; ++i) {
            Segment segment = this.segments.get(i);
            switch (segment.type) {
                case FIXED: {
                    fixedSegments.add(segment);
                    continue block6;
                }
                case VARIABLE: {
                    Segment subSegment;
                    Object subValue = subs.call((Object)segment.value);
                    if (null == subValue) {
                        throw new URISyntaxException(segment.toString(), "No substitution found.", i);
                    }
                    try {
                        subSegment = Segment.valueOf(subValue.toString());
                    }
                    catch (IllegalArgumentException e) {
                        throw new URISyntaxException(segment.toString(), String.format("Substitution not a valid segment: %s", subValue), i);
                    }
                    if (!Segment.Type.FIXED.equals((Object)subSegment.type)) {
                        throw new URISyntaxException(segment.toString(), String.format("Substitution not a fixed segment: %s", subSegment), i);
                    }
                    fixedSegments.add(subSegment);
                }
            }
        }
        return new Path(fixedSegments);
    }

    public String toString() {
        return "/" + Joiner.on((String)"/").join(this.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path b = (Path)obj;
        return this.segments.equals(b.segments);
    }

    public static final class Segment {
        public final Type type;
        public final String value;
        private static final Pattern M_FIXED = Pattern.compile("[a-z0-9-_;]+");
        private static final Pattern M_VARIABLE = Pattern.compile("[a-z0-9-]+");

        private static Segment valueOf(String s) {
            int n = s.length();
            if (n <= 0) {
                throw new IllegalArgumentException();
            }
            if ('$' == s.charAt(0)) {
                String value = s.substring(1, n);
                if (!M_VARIABLE.matcher(value).matches()) {
                    throw new IllegalArgumentException();
                }
                return new Segment(Type.VARIABLE, value);
            }
            String value = s;
            if (!M_FIXED.matcher(value).matches()) {
                throw new IllegalArgumentException();
            }
            return new Segment(Type.FIXED, value);
        }

        private Segment(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            switch (this.type) {
                case FIXED: {
                    return this.value;
                }
                case VARIABLE: {
                    return "$" + this.value;
                }
            }
            throw new IllegalStateException();
        }

        public int hashCode() {
            int c = this.type.hashCode();
            c = 31 * c + this.value.hashCode();
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Segment)) {
                return false;
            }
            Segment b = (Segment)obj;
            return this.type.equals((Object)b.type) && this.value.equals(b.value);
        }

        public static enum Type {
            FIXED,
            VARIABLE;

        }
    }
}

