/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.net.HttpHeaders;
import com.google.common.net.MediaType;
import io.nextop.EncodedImage;
import io.nextop.Id;
import io.nextop.Path;
import io.nextop.Route;
import io.nextop.WireValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import rx.functions.Func1;

public class Message {
    public static final WireValue P_CONTENT = WireValue.of("$content");
    public static final WireValue P_FRAGMENT = WireValue.of("$fragment");
    public static final Id DEFAULT_GROUP_ID = Id.create(0L, 0L, 0L, 0L);
    public static final int DEFAULT_GROUP_PRIORITY = 0;
    public static final WireValue P_PROGRESS = WireValue.of("progress");
    public final Id id;
    public final Id groupId;
    public final int groupPriority;
    public final Route route;
    public final Map<WireValue, WireValue> headers;
    public final Map<WireValue, WireValue> parameters;
    private static final String H_PRAGMA_ID_PREFIX = "nextop-id";
    private static final String H_PRAGMA_PREFIX = "nextop-header";
    private static final String H_PRAGMA_IMAGE_SIZE_PREFIX = "image-size";
    private static final Set<String> ALL_HTTP_HEADERS;

    public static Route outboxRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.PUT, Path.valueOf(id.toString())));
    }

    public static Route inboxRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.POST, Path.valueOf(id.toString())));
    }

    public static Route echoRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.GET, Path.valueOf("/" + id)));
    }

    public static Route echoHeadRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.HEAD, Path.valueOf("/" + id)));
    }

    public static Route statusRoute(Id id) {
        return Route.local(Route.Target.create(Route.Method.GET, Path.valueOf("/" + id + "/status")));
    }

    public static Message valueOf(Route.Method method, URL url) {
        try {
            return Message.valueOf(method, url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Message valueOf(Route.Method method, URI uri) {
        return Message.newBuilder().setRoute(Route.valueOf(String.format("%s %s", new Object[]{method, uri}))).build();
    }

    Message(Id id, Id groupId, int groupPriority, Route route, Map<WireValue, WireValue> headers, Map<WireValue, WireValue> parameters) {
        this.id = id;
        this.groupId = groupId;
        this.groupPriority = groupPriority;
        this.route = route;
        this.headers = headers;
        this.parameters = parameters;
    }

    public Route outboxRoute() {
        return Message.outboxRoute(this.id);
    }

    public Route inboxRoute() {
        return Message.inboxRoute(this.id);
    }

    public Route echoRoute() {
        return Message.echoRoute(this.id);
    }

    public Route echoHeadRoute() {
        return Message.echoHeadRoute(this.id);
    }

    public Route statusRoute() {
        return Message.statusRoute(this.id);
    }

    @Nullable
    public WireValue getContent() {
        return this.parameters.get(P_CONTENT);
    }

    public URI toUri() throws URISyntaxException {
        return Message.toUri(this);
    }

    public HttpUriRequest toHttpRequest() throws URISyntaxException {
        return Message.toHttpRequest(this);
    }

    public Builder buildOn() {
        return this.toBuilder(false);
    }

    public Builder toBuilder() {
        return this.toBuilder(true);
    }

    private Builder toBuilder(boolean newId) {
        Builder b = (newId ? Message.newBuilder() : Message.newBuilder(this.id)).setGroupId(this.groupId).setGroupPriority(this.groupPriority).setRoute(this.route);
        for (Map.Entry<WireValue, WireValue> e : this.headers.entrySet()) {
            b = b.setHeader(e.getKey(), e.getValue());
        }
        for (Map.Entry<WireValue, WireValue> e : this.parameters.entrySet()) {
            b = b.set(e.getKey(), e.getValue());
        }
        return b;
    }

    public static Builder newBuilder() {
        return Message.newBuilder(Id.create());
    }

    public static Builder newBuilder(Id id) {
        return new Builder(id);
    }

    public static URI toUri(final Message message) throws URISyntaxException {
        Path fixedPath = message.route.target.path.fix(new Func1<String, Object>(){

            public Object call(String s) {
                return message.parameters.get(WireValue.of(s));
            }
        });
        HashSet<String> pathVariableNames = new HashSet<String>(4);
        for (Path.Segment segment : message.route.target.path.segments) {
            if (!Path.Segment.Type.VARIABLE.equals((Object)segment.type)) continue;
            pathVariableNames.add(segment.value);
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append((Object)message.route.via.scheme);
        sb.append("://");
        sb.append(message.route.via.authority);
        sb.append(fixedPath);
        int c = 0;
        for (Map.Entry<WireValue, WireValue> e : message.parameters.entrySet()) {
            WireValue key = e.getKey();
            WireValue value = e.getValue();
            if (P_CONTENT.equals(key) || pathVariableNames.contains(key.toText())) continue;
            if (1 == ++c) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(key.toText()).append("=").append(value.toText());
        }
        return URI.create(sb.toString());
    }

    public static HttpUriRequest toHttpRequest(Message message) throws URISyntaxException {
        switch (message.route.target.method) {
            case GET: {
                HttpGet get = new HttpGet();
                get.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)get);
                return get;
            }
            case POST: {
                HttpPost post = new HttpPost();
                post.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)post);
                Message.attachContent(message, (HttpEntityEnclosingRequestBase)post);
                return post;
            }
            case PUT: {
                HttpPut put = new HttpPut();
                put.setURI(message.toUri());
                Message.attachHeaders(message, (HttpRequest)put);
                Message.attachContent(message, (HttpEntityEnclosingRequestBase)put);
                return put;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Builder fromHttpResponse(HttpResponse response) {
        Builder builder = Message.newBuilder();
        Message.attachHeaders(response, builder);
        Message.attachContent(response, builder);
        return builder;
    }

    public static Message fromHttpRequest(HttpUriRequest request) {
        return null;
    }

    public static HttpResponse toHttpResponse(Message message) {
        return null;
    }

    private static void attachHeaders(Message message, HttpRequest request) {
        request.addHeader("Pragma", String.format("%s %s", H_PRAGMA_ID_PREFIX, message.id));
        for (Map.Entry<WireValue, WireValue> e : message.headers.entrySet()) {
            WireValue key = e.getKey();
            WireValue value = e.getValue();
            String keyString = key.toString();
            if (ALL_HTTP_HEADERS.contains(keyString)) {
                request.setHeader(keyString, value.toText());
                continue;
            }
            request.addHeader("Pragma", String.format("%s %s", H_PRAGMA_PREFIX, WireValue.of(Arrays.asList(key, value)).toJson()));
        }
    }

    private static void attachContent(Message message, HttpEntityEnclosingRequestBase request) {
        block10: {
            StringEntity entity;
            block12: {
                WireValue content;
                block11: {
                    content = message.parameters.get(P_CONTENT);
                    if (null == content) break block10;
                    MediaType contentType = Message.getContentType(message, content);
                    if (contentType.is(MediaType.JSON_UTF_8)) {
                        try {
                            entity = new StringEntity(content.toJson());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    if (contentType.is(MediaType.ANY_TEXT_TYPE)) {
                        try {
                            entity = new StringEntity(content.toText());
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    if (!contentType.is(MediaType.ANY_IMAGE_TYPE)) break block11;
                    switch (content.getType()) {
                        case IMAGE: {
                            EncodedImage image = content.asImage();
                            entity = new ByteArrayEntity(Arrays.copyOfRange(image.bytes, image.offset, image.length));
                            if (0 < image.width || 0 < image.height) {
                                request.addHeader("Pragma", String.format("%s %d %d", H_PRAGMA_IMAGE_SIZE_PREFIX, image.width, image.height));
                                break;
                            }
                            break block12;
                        }
                        default: {
                            ByteBuffer bb = content.asBlob();
                            byte[] bytes = new byte[bb.remaining()];
                            bb.get(bytes);
                            entity = new ByteArrayEntity(bytes);
                            break;
                        }
                    }
                    break block12;
                }
                ByteBuffer bb = content.asBlob();
                byte[] bytes = new byte[bb.remaining()];
                bb.get(bytes);
                entity = new ByteArrayEntity(bytes);
            }
            request.setEntity((HttpEntity)entity);
        }
    }

    private static MediaType getContentType(Message message, WireValue content) {
        WireValue contentTypeValue = message.headers.get(WireValue.of("Content-Type"));
        if (null != contentTypeValue) {
            return MediaType.parse((String)contentTypeValue.asString());
        }
        switch (content.getType()) {
            case IMAGE: {
                switch (content.asImage().format) {
                    case WEBP: {
                        return MediaType.WEBP;
                    }
                    case JPEG: {
                        return MediaType.JPEG;
                    }
                    case PNG: {
                        return MediaType.PNG;
                    }
                }
                throw new IllegalArgumentException();
            }
            case BLOB: {
                return MediaType.APPLICATION_BINARY;
            }
            case UTF8: {
                return MediaType.PLAIN_TEXT_UTF_8;
            }
        }
        return MediaType.JSON_UTF_8;
    }

    private static void attachHeaders(HttpResponse response, Builder builder) {
        for (Header header : response.getAllHeaders()) {
            builder.setHeader(WireValue.of(header.getName()), WireValue.of(header.getValue()));
        }
    }

    private static void attachContent(HttpResponse response, Builder builder) {
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            builder.setContent(Message.createContent(response, entity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WireValue createContent(HttpResponse response, HttpEntity entity) {
        WireValue value;
        block14: {
            MediaType contentType = MediaType.parse((String)entity.getContentType().getValue());
            if (contentType.is(MediaType.JSON_UTF_8)) {
                try {
                    value = WireValue.valueOfJson(new InputStreamReader(entity.getContent(), Charsets.UTF_8));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (contentType.is(MediaType.ANY_TEXT_TYPE)) {
                try {
                    InputStreamReader r = new InputStreamReader(entity.getContent(), Charsets.UTF_8);
                    try {
                        value = WireValue.of(CharStreams.toString((Readable)r));
                        break block14;
                    }
                    finally {
                        ((Reader)r).close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            try {
                InputStream is = entity.getContent();
                try {
                    value = WireValue.of(ByteStreams.toByteArray((InputStream)is));
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return value;
    }

    static {
        HashSet<String> httpHeaders = new HashSet<String>(256);
        for (Field f : HttpHeaders.class.getFields()) {
            int m = f.getModifiers();
            try {
                if (!Modifier.isPublic(m) || !Modifier.isStatic(m)) continue;
                httpHeaders.add(f.get(null).toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        ALL_HTTP_HEADERS = ImmutableSet.copyOf(httpHeaders);
    }

    public static final class Builder {
        private final Id id;
        private Id groupId = DEFAULT_GROUP_ID;
        private int groupPriority = 0;
        @Nullable
        private Route.Target target = null;
        @Nullable
        private Route.Via via = null;
        private Map<WireValue, WireValue> headers = new HashMap<WireValue, WireValue>(8);
        private Map<WireValue, WireValue> parameters = new HashMap<WireValue, WireValue>(8);

        private Builder(Id id) {
            this.id = id;
        }

        public Builder setGroupId(Id groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setGroupPriority(int groupPriority) {
            this.groupPriority = groupPriority;
            return this;
        }

        public Builder setTarget(@Nullable Route.Target target) {
            this.target = target;
            return this;
        }

        public Builder setTarget(@Nullable String target) {
            this.target = null != target ? Route.Target.valueOf(target) : null;
            return this;
        }

        public Builder setVia(@Nullable Route.Via via) {
            this.via = via;
            return this;
        }

        public Builder setVia(@Nullable String via) {
            this.via = null != via ? Route.Via.valueOf(via) : null;
            return this;
        }

        public Builder setRoute(@Nullable Route route) {
            if (null != route) {
                this.target = route.target;
                this.via = route.via;
            } else {
                this.target = null;
                this.via = null;
            }
            return this;
        }

        public Builder setRoute(@Nullable String s) {
            if (null != s) {
                Route route = Route.valueOf(s);
                this.target = route.target;
                this.via = route.via;
            } else {
                this.target = null;
                this.via = null;
            }
            return this;
        }

        public Builder setHeader(Object name, @Nullable Object value) {
            if (null != value) {
                this.headers.put(WireValue.of(name), WireValue.of(value));
            } else {
                this.headers.remove(WireValue.of(name));
            }
            return this;
        }

        public Builder setContent(@Nullable Object value) {
            return this.set(P_CONTENT, value);
        }

        public Builder set(Object name, @Nullable Object value) {
            if (null != value) {
                this.parameters.put(WireValue.of(name), WireValue.of(value));
            } else {
                this.parameters.remove(WireValue.of(name));
            }
            return this;
        }

        public Message build() {
            if (null == this.target) {
                throw new IllegalStateException();
            }
            Route route = null != this.via ? Route.create(this.target, this.via) : Route.local(this.target);
            return new Message(this.id, this.groupId, this.groupPriority, route, (Map<WireValue, WireValue>)ImmutableMap.copyOf(this.headers), (Map<WireValue, WireValue>)ImmutableMap.copyOf(this.parameters));
        }
    }
}

