/*
 * Decompiled with CFR 0.152.
 */
package io.nextop;

import com.google.common.base.Objects;
import io.nextop.DomainName;
import io.nextop.Ip;
import javax.annotation.Nullable;

public final class Authority {
    public final Type type;
    @Nullable
    private final Object host;
    public final int port;

    public static Authority valueOf(String s) {
        int i;
        int n = s.length();
        if (n <= 0) {
            return Authority.local();
        }
        for (i = n - 1; 0 <= i && ':' != s.charAt(i); --i) {
        }
        if (i < 0) {
            try {
                return Authority.create(Ip.valueOf(s), 0);
            }
            catch (IllegalArgumentException e) {
                return Authority.create(DomainName.valueOf(s), 0);
            }
        }
        try {
            return Authority.create(Ip.valueOf(s.substring(0, i)), Integer.parseInt(s.substring(i + 1, n)));
        }
        catch (IllegalArgumentException e) {
            try {
                return Authority.create(DomainName.valueOf(s.substring(0, i)), Integer.parseInt(s.substring(i + 1, n)));
            }
            catch (IllegalArgumentException e2) {
                return Authority.create(DomainName.valueOf(s), 0);
            }
        }
    }

    public static Authority create(Ip host, int port) {
        Authority.validatePort(port);
        return new Authority(Type.IP, host, port);
    }

    public static Authority create(DomainName host, int port) {
        Authority.validatePort(port);
        return new Authority(Type.NAMED, host, port);
    }

    public static Authority local() {
        return new Authority(Type.LOCAL, null, 0);
    }

    private static void validatePort(int port) {
        if ((port & 0xFFFF) != port) {
            throw new IllegalArgumentException();
        }
    }

    private Authority(Type type, @Nullable Object host, int port) {
        this.type = type;
        this.host = host;
        this.port = port;
    }

    public Ip getIp() {
        switch (this.type) {
            case IP: {
                return (Ip)this.host;
            }
        }
        throw new IllegalStateException();
    }

    public DomainName getDomainName() {
        switch (this.type) {
            case IP: {
                return (DomainName)this.host;
            }
        }
        throw new IllegalStateException();
    }

    public String getHost() {
        return this.host.toString();
    }

    public String toString() {
        switch (this.type) {
            case IP: 
            case NAMED: {
                if (0 < this.port) {
                    return String.format("%s:%d", this.host, this.port);
                }
                return String.format("%s", this.host);
            }
            case LOCAL: {
                return "";
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Authority)) {
            return false;
        }
        Authority b = (Authority)o;
        return this.type.equals((Object)b.type) && this.port == b.port && Objects.equal((Object)this.host, (Object)b.host);
    }

    public int hashCode() {
        int m = 31;
        int c = this.type.hashCode();
        c = m * c + Objects.hashCode((Object[])new Object[]{this.host});
        c = m * c + Integer.hashCode(this.port);
        return c;
    }

    static enum Type {
        IP,
        NAMED,
        LOCAL;

    }
}

