package io.naraplatform.daysman.mediator.spec.util;

import com.google.protobuf.Empty;
import io.naradrama.prologue.domain.Offset;
import io.naradrama.prologue.domain.cqrs.DomainMessageType;
import io.naradrama.prologue.domain.cqrs.broker.StreamEventMessage;
import io.naraplatform.daysman.mediator.spec.domain.Subscription;
import io.naraplatform.daysman.mediator.spec.proto.*;

import java.util.List;
import java.util.stream.Collectors;

public abstract class GrpcMessage {
    //
    public static Empty toEmpty() {
        //
        return Empty.newBuilder().build();
    }

    public static StreamEventMessage toStreamEventMessage(StreamEventMessageMsg message) {
        //
        StreamEventMessage streamEventMessage = new StreamEventMessage();
        streamEventMessage.setId(message.getId());
        streamEventMessage.setDomainMessageType(DomainMessageType.valueOf(message.getDomainMessageType()));
        streamEventMessage.setTimestamp(message.getTimestamp());
        streamEventMessage.setPayloadClass(message.getPayloadClass());
        streamEventMessage.setPayload(message.getPayload());
        streamEventMessage.setServiceName(message.getServiceName());
        return streamEventMessage;
    }

    public static StreamEventMessageMsg toStreamEventMessageMsg(StreamEventMessage streamEventMessage) {
        //
        return StreamEventMessageMsg.newBuilder()
                .setDomainMessageType(streamEventMessage.getDomainMessageType().name())
                .setId(streamEventMessage.getId())
                .setTimestamp(streamEventMessage.getTimestamp())
                .setPayload(streamEventMessage.getPayload())
                .setPayloadClass(streamEventMessage.getPayloadClass())
                .setServiceName(streamEventMessage.getServiceName())
                .build();
    }

    public static LoadRequest toLoadRequest(String id) {
        //
        return LoadRequest.newBuilder()
                .setId(id)
                .build();
    }

    public static LoadResponse toLoadResponse(List<StreamEventMessage> events) {
        //
        return LoadResponse.newBuilder()
                .addAllStreamEvents(toStreamEventMessageMsgs(events))
                .build();
    }

    public static List<StreamEventMessageMsg> toStreamEventMessageMsgs(List<StreamEventMessage> events) {
        //
        return events.stream()
                .map(GrpcMessage::toStreamEventMessageMsg)
                .collect(Collectors.toList());
    }

    public static SubscriptionList toSubscriptionList(List<Subscription> subscriptions) {
        //
        return SubscriptionList.newBuilder()
                .addAllSubscriptions(toSubscriptionMessages(subscriptions))
                .build();
    }

    public static List<SubscriptionMessage> toSubscriptionMessages(List<Subscription> subscriptions) {
        //
        return subscriptions.stream()
                .map(GrpcMessage::toSubscriptionMessage)
                .collect(Collectors.toList());
    }

    public static SubscriptionMessage toSubscriptionMessage(Subscription subscription) {
        //
        return SubscriptionMessage.newBuilder()
                .setId(subscription.getId())
                .setConsumerId(subscription.getConsumerId())
                .setConsumerHost(subscription.getConsumerHost())
                .setConsumerPort(subscription.getConsumerPort())
                .setServiceId(subscription.getServiceId())
                .build();
    }

    public static SubscriptionRequest toSubscriptionRequest(String consumerId, String consumerHost, int consumerPort, String serviceId) {
        //
        return SubscriptionRequest.newBuilder()
                .setConsumerId(consumerId)
                .setConsumerHost(consumerHost)
                .setConsumerPort(consumerPort)
                .setServiceId(serviceId)
                .build();
    }

    public static SubscriberReadRequest toSubscriberReadRequest(String serviceId) {
        //
        return SubscriberReadRequest.newBuilder()
                .setServiceId(serviceId)
                .build();
    }

    public static SubscriptionReadRequest toSubscriptionReadRequest(String consumerId) {
        //
        return SubscriptionReadRequest.newBuilder()
                .setConsumerId(consumerId)
                .build();
    }

    public static List<Subscription> toSubscriptions(SubscriptionList subscriptionList) {
        //
        return toSubscriptions(subscriptionList.getSubscriptionsList());
    }

    public static List<Subscription> toSubscriptions(List<SubscriptionMessage> messages) {
        //
        return messages.stream()
                .map(GrpcMessage::toSubscription)
                .collect(Collectors.toList());
    }

    public static Subscription toSubscription(SubscriptionMessage message) {
        //
        Subscription subscription = new Subscription(message.getId());
        subscription.setConsumerId(message.getConsumerId());
        subscription.setConsumerHost(message.getConsumerHost());
        subscription.setConsumerPort(message.getConsumerPort());
        subscription.setServiceId(message.getServiceId());
        return subscription;
    }

    public static OffsetMessage toOffsetMessage(Offset offset) {
        //
        return OffsetMessage.newBuilder()
                .setOffset(offset.getOffset())
                .setLimit(offset.getLimit())
                .build();
    }

    public static Offset toOffset(OffsetMessage message) {
        //
        return new Offset(message.getOffset(), message.getLimit());
    }
}
