package io.naraplatform.daysman.mediator.spec.store;

import io.naraplatform.daysman.mediator.spec.domain.Subscription;

import java.util.List;

public interface SubscriptionStore {
    //
    String save(Subscription subscription);
    Subscription load(String id);
    List<Subscription> loadAll();
    List<Subscription> loadByServiceId(String serviceId);
    List<Subscription> loadByConsumerId(String consumerId);
    boolean exist(String consumerId, String consumerHost, int consumerPort, String serviceId);
    Subscription loadByConsumerAndServiceId(String consumerId, String consumerHost, int consumerPort, String serviceId);
    void delete(String id);
}
