package io.naraplatform.daysman.mediator.spec.domain;

import io.naradrama.prologue.domain.ddd.DomainEntity;
import io.naradrama.prologue.util.json.JsonUtil;
import lombok.Getter;
import lombok.Setter;

import java.util.UUID;

@Getter
@Setter
public class Subscription extends DomainEntity {
    //
    private String consumerId;
    private String consumerHost;  // ex) 10.50.0.1, localhost
    private int consumerPort;     // consumer's gRPC port
    private String serviceId;

    public Subscription(String id) {
        //
        super(id);
    }

    public Subscription(String consumerId, String consumerHost, int consumerPort, String serviceId) {
        //
        super(UUID.randomUUID().toString());
        this.consumerId = consumerId;
        this.consumerHost = consumerHost;
        this.consumerPort = consumerPort;
        this.serviceId = serviceId;
    }

    public String toString() {
        //
        return toJson();
    }

    public static Subscription fromJson(String json) {
        //
        return JsonUtil.fromJson(json, Subscription.class);
    }
}
