package io.naraplatform.daysman.mediator.spec.domain;

import io.naradrama.prologue.domain.ddd.DomainEntity;
import lombok.Getter;
import lombok.Setter;

import java.sql.Timestamp;
import java.util.UUID;

@Getter
@Setter
public class EventSent extends DomainEntity {
    //
    private String eventId;
    private String serviceId;
    private String consumerId;
    private String consumerHost;
    private int consumerPort;
    private String timestamp;

    private boolean received;

    public EventSent(String id) {
        //
        super(id);
    }

    public EventSent(String eventId, String serviceId, String consumerId, String consumerHost, int consumerPort) {
        //
        super(UUID.randomUUID().toString());
        this.eventId = eventId;
        this.serviceId = serviceId;
        this.consumerId = consumerId;
        this.consumerHost = consumerHost;
        this.consumerPort = consumerPort;
        this.timestamp = new Timestamp(System.currentTimeMillis()).toString();
    }

    public static EventSent newEventSent(Subscription subscription, String dramaEventId) {
        //
        return new EventSent(dramaEventId, subscription.getServiceId(), subscription.getConsumerId(),
                subscription.getConsumerHost(), subscription.getConsumerPort());
    }

    // FIXME : working
    public static String createBaseSentId() {
        return UUID.randomUUID().toString();
    }

    public static String createEventSentId(String baseSentId, String consumerId, String consumerHost, int consumerPort) {
        return baseSentId + "-" + consumerId + ":" + consumerHost + ":" + consumerPort;
    }


    public static EventSent newEventSent(String baseSentId, Subscription subscription, String dramaEventId) {
        //
        String eventSentId = createEventSentId(baseSentId, subscription.getConsumerId(), subscription.getConsumerHost(), subscription.getConsumerPort());
        EventSent eventSent = new EventSent(eventSentId);
        eventSent.setEventId(dramaEventId);
        eventSent.setServiceId(subscription.getServiceId());
        eventSent.setConsumerId(subscription.getConsumerId());
        eventSent.setConsumerHost(subscription.getConsumerHost());
        eventSent.setConsumerPort(subscription.getConsumerPort());
        return eventSent;
    }
    ////
}
