package io.naraplatform.daysman.mediator.spec.domain;

import io.naradrama.prologue.domain.ddd.DomainEntity;
import lombok.Getter;
import lombok.Setter;

import java.sql.Timestamp;
import java.util.UUID;

@Getter
@Setter
public class EventReceived extends DomainEntity {
    //
    private String eventSentId;
    private String timestamp;

    private EventReceived() {
        //
    }

    public EventReceived(String id) {
        //
        super(id);
    }

    public static EventReceived newEventReceived(String eventSentId) {
        //
        EventReceived received = new EventReceived();
        received.setId(UUID.randomUUID().toString());
        received.setEventSentId(eventSentId);
        received.setTimestamp(new Timestamp(System.currentTimeMillis()).toString());
        return received;
    }

}
