/*
 * Decompiled with CFR 0.152.
 */
package io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher;

import io.mzlnk.springframework.multitenant.oauth2.resourceserver.properties.AuthenticationTenantDetails;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher.AbstractAuthenticationTenantMatcher;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher.AuthenticationTenantMatcher;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public class HeaderAuthenticationTenantMatcher
extends AbstractAuthenticationTenantMatcher {
    private final String headerName;
    private final String headerValue;

    public HeaderAuthenticationTenantMatcher(String providerId, String headerName, String headerValue) {
        super(providerId);
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader(this.headerName)).map(this.headerValue::equals).orElse(false);
    }

    public static class Factory
    implements AuthenticationTenantMatcher.Factory {
        @Override
        public String getType() {
            return "HEADER";
        }

        @Override
        public AuthenticationTenantMatcher create(String providerId, AuthenticationTenantDetails.MatcherDetails matcherDetails) {
            String headerName = matcherDetails.getProperty("header-name");
            String headerValue = matcherDetails.getProperty("header-value");
            Assert.notNull((Object)headerName, (String)"Property header-name cannot be null");
            Assert.notNull((Object)headerValue, (String)"Property header-value cannot be null");
            return new HeaderAuthenticationTenantMatcher(providerId, headerName, headerValue);
        }
    }
}

