/*
 * Decompiled with CFR 0.152.
 */
package io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher;

import io.mzlnk.springframework.multitenant.oauth2.resourceserver.properties.AuthenticationTenantDetails;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher.AbstractAuthenticationTenantMatcher;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.tenant.matcher.AuthenticationTenantMatcher;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;

public class CookieAuthenticationTenantMatcher
extends AbstractAuthenticationTenantMatcher {
    private final String cookieName;
    private final String cookieValue;

    public CookieAuthenticationTenantMatcher(String providerId, String cookieName, String cookieValue) {
        super(providerId);
        this.cookieName = cookieName;
        this.cookieValue = cookieValue;
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return Stream.ofNullable(request.getCookies()).flatMap(Arrays::stream).anyMatch(cookie -> cookie.getName().equals(this.cookieName) && cookie.getValue().equals(this.cookieValue));
    }

    public static class Factory
    implements AuthenticationTenantMatcher.Factory {
        @Override
        public String getType() {
            return "COOKIE";
        }

        @Override
        public AuthenticationTenantMatcher create(String providerId, AuthenticationTenantDetails.MatcherDetails matcherDetails) {
            String cookieName = matcherDetails.getProperty("cookie-name");
            String cookieValue = matcherDetails.getProperty("cookie-value");
            Assert.notNull((Object)cookieName, (String)"Property cookie-name cannot be null");
            Assert.notNull((Object)cookieValue, (String)"Property cookie-value cannot be null");
            return new CookieAuthenticationTenantMatcher(providerId, cookieName, cookieValue);
        }
    }
}

