/*
 * Decompiled with CFR 0.152.
 */
package io.mzlnk.springframework.multitenant.oauth2.resourceserver.context;

import io.mzlnk.springframework.multitenant.oauth2.resourceserver.context.AuthenticationTenantContext;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.context.AuthenticationTenantContextHolderStrategy;
import io.mzlnk.springframework.multitenant.oauth2.resourceserver.context.AuthenticationTenantContextImpl;
import org.springframework.util.Assert;

public class ThreadLocalAuthenticationTenantContextHolderStrategy
implements AuthenticationTenantContextHolderStrategy {
    private final ThreadLocal<AuthenticationTenantContext> contextHolder = new InheritableThreadLocal<AuthenticationTenantContext>();

    ThreadLocalAuthenticationTenantContextHolderStrategy() {
    }

    @Override
    public String getName() {
        return "STRATEGY_THREAD_LOCAL";
    }

    @Override
    public void clearContext() {
        this.contextHolder.remove();
    }

    @Override
    public AuthenticationTenantContext getContext() {
        AuthenticationTenantContext context = this.contextHolder.get();
        if (context == null) {
            context = this.createEmptyContext();
            this.contextHolder.set(context);
        }
        return context;
    }

    @Override
    public void setContext(AuthenticationTenantContext context) {
        Assert.notNull((Object)context, (String)"Only non-null AuthenticationTenantContext instances are permitted");
        this.contextHolder.set(context);
    }

    @Override
    public AuthenticationTenantContext createEmptyContext() {
        return new AuthenticationTenantContextImpl();
    }
}

