/*
 * Decompiled with CFR 0.152.
 */
package io.morethan.daggerdoc.result;

import com.google.common.io.BaseEncoding;
import io.morethan.daggerdoc.ResultWriter;
import io.morethan.daggerdoc.model.DependencyGraph;
import io.morethan.daggerdoc.model.LinkType;
import io.morethan.daggerdoc.model.NodeType;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class MermaidResultWriter
implements ResultWriter {
    @Override
    public String id() {
        return "mermaid";
    }

    @Override
    public void write(ProcessingEnvironment processingEnv, DependencyGraph dependencyGraph) {
        try {
            FileObject outputFile = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "dagger-dependencies.md", new Element[0]);
            StringWriter base64Writer = new StringWriter();
            try (FilePrinter ouput = new FilePrinter(outputFile, base64Writer);){
                ouput.println("graph BT");
                ouput.println();
                dependencyGraph.nodes().stream().filter(node -> node.type() == NodeType.COMPONENT).forEach(node -> ouput.printf("%s[%<s]", node.name()));
                ouput.println();
                dependencyGraph.nodes().stream().filter(node -> node.type() == NodeType.MODULE).forEach(node -> ouput.printf("%s(%<s)", node.name()));
                ouput.println();
                dependencyGraph.links().stream().filter(link -> link.type() == LinkType.DEPENDS_ON && link.node1().type() == NodeType.COMPONENT).forEach(link -> ouput.printf("%s ==> %s", link.node2().name(), link.node1().name()));
                dependencyGraph.links().stream().filter(link -> link.type() == LinkType.DEPENDS_ON && link.node1().type() == NodeType.MODULE).forEach(link -> ouput.printf("%s --> %s", link.node2().name(), link.node1().name()));
                dependencyGraph.links().stream().filter(link -> link.type() == LinkType.CONTRIBUTES_TO).forEach(link -> ouput.printf("%s -.-> %s", link.node1().name(), link.node2().name()));
            }
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Written result file to file://" + outputFile.getName(), null);
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Open at https://mermaidjs.github.io/mermaid-live-editor/#/edit/" + ((Object)base64Writer).toString(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class FilePrinter
    implements AutoCloseable {
        private final PrintWriter _fileWriter;
        private final PrintWriter _base64Writer;

        public FilePrinter(FileObject outputFile, Writer base64Writer) {
            try {
                this._fileWriter = new PrintWriter(new OutputStreamWriter(outputFile.openOutputStream(), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this._base64Writer = new PrintWriter(BaseEncoding.base64().encodingStream(base64Writer));
        }

        public void println() {
            this._fileWriter.println();
            this._base64Writer.println();
        }

        public void println(String string) {
            this._fileWriter.println(string);
            this._base64Writer.println(string);
        }

        public void printf(String template, Object ... values) {
            this.println(String.format(template, values));
        }

        @Override
        public void close() {
            this._fileWriter.close();
            this._base64Writer.close();
        }
    }
}

