/*
 * Decompiled with CFR 0.152.
 */
package io.morethan.daggerdoc.model;

import com.google.common.base.Verify;
import io.morethan.daggerdoc.model.Link;
import io.morethan.daggerdoc.model.LinkType;
import io.morethan.daggerdoc.model.Linker;
import io.morethan.daggerdoc.model.MultibindingLinker;
import io.morethan.daggerdoc.model.Node;
import io.morethan.daggerdoc.model.NodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class DependencyGraph {
    private final Set<Node> _nodes;
    private final Set<Link> _links;

    private DependencyGraph(Set<Node> nodes, Set<Link> links) {
        this._nodes = nodes;
        this._links = links;
    }

    public Set<Node> nodes() {
        return this._nodes;
    }

    public Set<Link> links() {
        return this._links;
    }

    public static Builder builder() {
        return new Builder();
    }

    static class TypeString {
        private final String _typeString;

        public TypeString(TypeMirror typeMirror) {
            this._typeString = typeMirror.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._typeString == null ? 0 : this._typeString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeString other = (TypeString)obj;
            return !(this._typeString == null ? other._typeString != null : !this._typeString.equals(other._typeString));
        }

        public String toString() {
            return this._typeString;
        }
    }

    public static class Builder {
        private final Map<String, Node> _nodeById = new HashMap<String, Node>();
        private final List<Linker> _linkers = new ArrayList<Linker>();
        private final Set<MultibindingLinker> _multibindingLinkers = new HashSet<MultibindingLinker>();
        private final Map<TypeString, String> _multibindingConsumers = new HashMap<TypeString, String>();

        public Node addNode(Element element, NodeType type) {
            String id = this.nodeId(element);
            Node node = this._nodeById.get(id);
            if (node != null) {
                Verify.verify((node.type() == type ? 1 : 0) != 0, (String)"Can't register node for %s of type %s since it is already registered with type %s", (Object)id, (Object)((Object)type), (Object)((Object)node.type()));
            } else {
                node = new Node(element.getSimpleName().toString(), type);
                this._nodeById.put(id, node);
            }
            return node;
        }

        public void addDependency(Element element, TypeMirror typeMirror) {
            this._linkers.add(new Linker(this.nodeId(element), Builder.nodeId(typeMirror)));
        }

        public void addMultibindingLink(Element element, TypeMirror multibindinType) {
            this._multibindingLinkers.add(new MultibindingLinker(this.nodeId(element), multibindinType));
        }

        public void addMultibindingConsumer(Element containerElement, TypeMirror multiBindingType) {
            this._multibindingConsumers.put(new TypeString(multiBindingType), this.nodeId(containerElement));
        }

        private String nodeId(Element element) {
            return element.toString();
        }

        private static String nodeId(TypeMirror typeMirror) {
            return typeMirror.toString();
        }

        public DependencyGraph build() {
            Set<Link> links = this.resolveLinks();
            return new DependencyGraph(new HashSet<Node>(this._nodeById.values()), links);
        }

        private Set<Link> resolveLinks() {
            Node node1;
            HashSet<Link> links = new HashSet<Link>();
            for (Linker linker : this._linkers) {
                node1 = (Node)Verify.verifyNotNull((Object)this._nodeById.get(linker.nodeId1()), (String)"Could not resolve %s", (Object[])new Object[]{linker.nodeId1()});
                Node node2 = (Node)Verify.verifyNotNull((Object)this._nodeById.get(linker.nodeId2()), (String)"Could not resolve %s", (Object[])new Object[]{linker.nodeId2()});
                links.add(new Link(node1, node2, LinkType.DEPENDS_ON));
            }
            for (MultibindingLinker multibindingLinker : this._multibindingLinkers) {
                node1 = (Node)Verify.verifyNotNull((Object)this._nodeById.get(multibindingLinker.nodeId()), (String)"Could not resolve %s", (Object[])new Object[]{multibindingLinker.nodeId()});
                String nodeId2 = (String)Verify.verifyNotNull((Object)this._multibindingConsumers.get(multibindingLinker.multibindingType()), (String)"Did not find multibinding sink for type %s", (Object[])new Object[]{multibindingLinker.multibindingType()});
                Node node2 = (Node)Verify.verifyNotNull((Object)this._nodeById.get(nodeId2), (String)"Could not resolve %s", (Object[])new Object[]{nodeId2});
                if (node1.equals(node2)) continue;
                links.add(new Link(node1, node2, LinkType.CONTRIBUTES_TO));
            }
            return links;
        }
    }
}

