/*
 * Decompiled with CFR 0.152.
 */
package io.morethan.daggerdoc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import io.morethan.daggerdoc.ResultWriter;
import io.morethan.daggerdoc.Util;
import io.morethan.daggerdoc.model.DependencyGraph;
import io.morethan.daggerdoc.model.NodeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class DaggerDocProcessor
extends AbstractProcessor {
    private static final String WRITERS_OPTION = "writers";
    private final DependencyGraph.Builder _graphBuilder = DependencyGraph.builder();
    private List<ResultWriter> _resultWriters;

    public DaggerDocProcessor() {
    }

    @VisibleForTesting
    public DaggerDocProcessor(ResultWriter resultWriter) {
        this._resultWriters = new ArrayList<ResultWriter>();
        this._resultWriters.add(resultWriter);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add("dagger.Component");
        annotations.add("dagger.Module");
        return annotations;
    }

    @Override
    public Set<String> getSupportedOptions() {
        Verify.verifyNotNull(this._resultWriters);
        ImmutableSet.Builder supportedOptions = ImmutableSet.builder();
        supportedOptions.add((Object)WRITERS_OPTION);
        for (ResultWriter resultWriter : this._resultWriters) {
            supportedOptions.addAll(resultWriter.supportedOptions());
        }
        return supportedOptions.build();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (this._resultWriters == null) {
            this._resultWriters = DaggerDocProcessor.loadResultWriters(processingEnv.getOptions(), processingEnv.getMessager());
        }
    }

    private static List<ResultWriter> loadResultWriters(Map<String, String> options, Messager messager) {
        ImmutableSet pickedWriters;
        Object resultWriters = ImmutableList.copyOf(ServiceLoader.load(ResultWriter.class, DaggerDocProcessor.class.getClassLoader()));
        Preconditions.checkState((resultWriters.size() > 0 ? 1 : 0) != 0, (String)"No instances of '%s' found!", (Object)ResultWriter.class.getName());
        String writersOption = options.get(WRITERS_OPTION);
        if (writersOption != null && (pickedWriters = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)writersOption))).size() > 0) {
            resultWriters = resultWriters.stream().filter(arg_0 -> DaggerDocProcessor.lambda$loadResultWriters$0((Set)pickedWriters, arg_0)).collect(Collectors.toList());
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "Activated result writers (writers=" + writersOption + "):", null);
        for (ResultWriter resultWriter : resultWriters) {
            messager.printMessage(Diagnostic.Kind.NOTE, "\t" + resultWriter.getClass().getName(), null);
        }
        return resultWriters;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Component.class)) {
            this._graphBuilder.addNode(element, NodeType.COMPONENT);
            Util.consumeAnnotationValues(element, Component.class, "modules", entry -> Util.consumeClassValues((AnnotationValue)entry.getValue(), typeMirror -> this._graphBuilder.addDependency(componentClass, (TypeMirror)typeMirror)));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Module.class)) {
            this._graphBuilder.addNode(element, NodeType.MODULE);
            Util.consumeAnnotationValues(element, Module.class, "includes", entry -> Util.consumeClassValues((AnnotationValue)entry.getValue(), typeMirror -> this._graphBuilder.addDependency(moduleClass, (TypeMirror)typeMirror)));
            element.getEnclosedElements().stream().filter(elem -> elem.getKind() == ElementKind.METHOD && elem.getAnnotation(Provides.class) != null).map(method -> (ExecutableElement)method).forEach(providesMethod -> {
                if (providesMethod.getAnnotation(IntoSet.class) != null) {
                    TypeMirror returnType = providesMethod.getReturnType();
                    this._graphBuilder.addMultibindingLink(moduleClass, returnType);
                }
                Util.ProvidesParamEvaluator typeVisitor = new Util.ProvidesParamEvaluator(this.processingEnv, this._graphBuilder, moduleClass);
                for (Element element : providesMethod.getParameters()) {
                    element.asType().accept(typeVisitor, null);
                }
            });
        }
        if (roundEnv.processingOver()) {
            for (ResultWriter resultWriter : this._resultWriters) {
                resultWriter.write(this.processingEnv, this._graphBuilder.build());
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$loadResultWriters$0(Set pickedWriters, ResultWriter writer) {
        return pickedWriters.contains(writer.id());
    }
}

