/*
 * Decompiled with CFR 0.152.
 */
package io.monalabs.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.fluentd.FluencyBuilderForFluentd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonaClient
implements Closeable {
    private static final String MONA_ARC_CLASS_FIELD_NAME = "MONA_ARC_CLASS";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MonaClient.class.getName());
    private final Timer TIMER = new Timer();
    private long exportCounter = 0L;
    private final Fluency fluency;
    private final String monaUserId;

    protected MonaClient(Fluency fluency, String monaUserId) {
        this.fluency = fluency;
        this.monaUserId = monaUserId;
        this.scheduleKeepAliveRequest();
    }

    private MonaClient(Builder builder) {
        FluencyBuilderForFluentd fluencyBuilder = new FluencyBuilderForFluentd();
        fluencyBuilder.setBufferChunkInitialSize(Integer.valueOf(builder.bufferChunkInitialSize));
        fluencyBuilder.setBufferChunkRetentionSize(Integer.valueOf(builder.bufferChunkRetentionSize));
        fluencyBuilder.setMaxBufferSize(Long.valueOf(builder.maxBufferSize));
        fluencyBuilder.setFlushIntervalMillis(Integer.valueOf(builder.flushIntervalMillis));
        fluencyBuilder.setSslEnabled(true);
        fluencyBuilder.setErrorHandler(e -> LOGGER.warn(String.format("Error sending data to Mona: %s", e.getMessage())));
        fluencyBuilder.setAckResponseMode(builder.ackResponseMode);
        fluencyBuilder.setConnectionTimeoutMilli(Integer.valueOf(builder.connectionTimeoutMilli));
        fluencyBuilder.setReadTimeoutMilli(Integer.valueOf(builder.readTimeoutMilli));
        fluencyBuilder.setSenderMaxRetryCount(Integer.valueOf(builder.senderMaxRetryCount));
        this.fluency = fluencyBuilder.build(builder.host, builder.port);
        this.monaUserId = builder.monaUserId;
        this.scheduleKeepAliveRequest();
    }

    @Override
    public void close() {
        try {
            this.fluency.close();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("IO Exception when closing link to fluentd: %s", e.getMessage()));
        }
        this.TIMER.cancel();
    }

    public long getCurrentUnsentDataSize() {
        return this.fluency.getBufferedDataSize();
    }

    private int amountOfDotsInString(String checkedString) {
        return checkedString.length() - checkedString.replace(".", "").length();
    }

    public void exportStandalone(String arcClass, String contextId, Map<String, Object> message) {
        int missingContextIdsCount;
        if (message == null) {
            LOGGER.warn("Tried to export null message");
            return;
        }
        if (message.isEmpty()) {
            LOGGER.warn("Tried to export empty message");
            return;
        }
        if (arcClass == null || arcClass.isEmpty()) {
            LOGGER.warn("Tried to export with empty ARC class");
            return;
        }
        if (arcClass.endsWith(".")) {
            LOGGER.warn("ARC classes cannot end with dots");
            return;
        }
        if (contextId == null) {
            contextId = "";
        }
        if (contextId.endsWith(".")) {
            LOGGER.warn("Context ids cannot end with dots");
            return;
        }
        if (contextId.isEmpty()) {
            contextId = UUID.randomUUID().toString();
        }
        if ((missingContextIdsCount = this.amountOfDotsInString(arcClass) - this.amountOfDotsInString(contextId)) < 0) {
            LOGGER.warn("Tried to export a context ID with more sub-contexts than in the given ARC class.");
            return;
        }
        StringBuilder contextBuilder = new StringBuilder().append(contextId);
        for (int i = 0; i < missingContextIdsCount; ++i) {
            contextBuilder.append(".");
            contextBuilder.append(UUID.randomUUID().toString());
        }
        contextId = contextBuilder.toString();
        HashMap<String, Object> output_inner_message = new HashMap<String, Object>(message);
        output_inner_message.put(MONA_ARC_CLASS_FIELD_NAME, arcClass);
        HashMap<String, Object> outerMessage = new HashMap<String, Object>();
        outerMessage.put("user_id", this.monaUserId);
        outerMessage.put("context", contextId);
        outerMessage.put("message", output_inner_message);
        outerMessage.put("export_timestamp", Instant.now().getEpochSecond());
        try {
            this.fluency.emit("mona.client.message", outerMessage);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("IO Exception when emitting to fluentd: %s", e.getMessage()));
        }
        ++this.exportCounter;
        this.scheduleKeepAliveRequest();
    }

    private void scheduleKeepAliveRequest() {
        final long currentCounter = this.exportCounter;
        this.TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                if (currentCounter == MonaClient.this.exportCounter) {
                    MonaClient.this.exportStandalone("MONA_KEEPALIVE", "MONA_KA", Collections.singletonMap("x", 1));
                }
            }
        }, 30000L);
    }

    public void exportStandalone(String arcClass, Map<String, Object> message) {
        this.exportStandalone(arcClass, "", message);
    }

    public void exportStandalone(String arcClass, List<Map<String, Object>> messages) {
        this.exportStandalone(arcClass, "", messages);
    }

    public void exportStandalone(String arcClass, String contextId, List<Map<String, Object>> messages) {
        if (messages == null) {
            LOGGER.warn("Tried to export null messages");
            return;
        }
        for (Map<String, Object> innerMessage : messages) {
            this.exportStandalone(arcClass, contextId, innerMessage);
        }
    }

    public void exportStandalone(String arcClass, String jsonString) {
        this.exportStandalone(arcClass, "", jsonString);
    }

    public void exportStandalone(String arcClass, String contextId, String jsonString) {
        if (jsonString == null) {
            LOGGER.warn("Tried to export null json String");
            return;
        }
        try {
            this.exportStandalone(arcClass, contextId, new JSONObject(jsonString));
        }
        catch (JSONException ex) {
            try {
                this.exportStandalone(arcClass, contextId, new JSONArray(jsonString));
            }
            catch (JSONException ex1) {
                LOGGER.warn("Bad Json String.");
            }
        }
    }

    public void exportStandalone(String arcClass, JSONObject jsonObject) {
        this.exportStandalone(arcClass, "", jsonObject);
    }

    public void exportStandalone(String arcClass, String contextId, JSONObject jsonObject) {
        if (jsonObject == null) {
            LOGGER.warn("Tried to export null JSONObject");
            return;
        }
        try {
            this.exportStandalone(arcClass, contextId, (Map)new ObjectMapper().readValue(jsonObject.toString(), HashMap.class));
        }
        catch (Exception e) {
            LOGGER.warn("Exception when trying to exportStandalone JSON object");
        }
    }

    public void exportStandalone(String arcClass, JSONArray jsonArray) {
        this.exportStandalone(arcClass, "", jsonArray);
    }

    public void exportStandalone(String arcClass, String contextId, JSONArray jsonArray) {
        if (jsonArray == null) {
            LOGGER.warn("Tried to export null JSONArray");
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.exportStandalone(arcClass, contextId, jsonArray.getJSONObject(i));
        }
    }

    public static class Builder {
        private static final int DEFAULT_BUFFER_CHUNK_INITIAL_SIZE = 102400;
        private static final int DEFAULT_BUFFER_CHUNK_RETENTION_SIZE = 204800;
        private static final long DEFAULT_MAX_BUFFER_SIZE = 0x200000L;
        private static final int DEFAULT_INTERVAL_MILLIS = 100;
        private static final int DEFAULT_CONNECTION_TIMEOUT_MILLI = 10000;
        private static final int DEFAULT_READ_TIMEOUT_MILLI = 10000;
        private static final int DEFAULT_SENDER_MAX_RETRY_COUNT = 10;
        private final String host;
        private final int port;
        private final String monaUserId;
        private int bufferChunkInitialSize;
        private int bufferChunkRetentionSize;
        private long maxBufferSize;
        private int flushIntervalMillis;
        private boolean ackResponseMode;
        private int connectionTimeoutMilli;
        private int readTimeoutMilli;
        private int senderMaxRetryCount;

        public Builder(String host, int port, String monaUserId) {
            this.host = host;
            this.port = port;
            this.monaUserId = monaUserId;
            this.bufferChunkInitialSize = 102400;
            this.bufferChunkRetentionSize = 204800;
            this.maxBufferSize = 0x200000L;
            this.flushIntervalMillis = 100;
            this.ackResponseMode = false;
            this.connectionTimeoutMilli = 10000;
            this.readTimeoutMilli = 10000;
            this.senderMaxRetryCount = 10;
        }

        public Builder setSenderMaxRetryCount(int senderMaxRetryCount) {
            this.senderMaxRetryCount = senderMaxRetryCount;
            return this;
        }

        public Builder setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
            return this;
        }

        public Builder setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
            return this;
        }

        public Builder setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
            return this;
        }

        public Builder setBufferChunkInitialSize(int bufferChunkInitialSize) {
            this.bufferChunkInitialSize = bufferChunkInitialSize;
            return this;
        }

        public Builder setBufferChunkRetentionSize(int bufferChunkRetentionSize) {
            this.bufferChunkRetentionSize = bufferChunkRetentionSize;
            return this;
        }

        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public MonaClient build() {
            return new MonaClient(this);
        }
    }
}

